/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.impl.cmd.NeedsActiveExecutionCmd;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.util.Activiti5Util;

public class MessageEventReceivedCmd
extends NeedsActiveExecutionCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected final Map<String, Object> payload;
    protected final String messageName;
    protected final boolean async;

    public MessageEventReceivedCmd(String messageName, String executionId, Map<String, Object> processVariables) {
        super(executionId);
        this.messageName = messageName;
        this.payload = processVariables != null ? new HashMap<String, Object>(processVariables) : null;
        this.async = false;
    }

    public MessageEventReceivedCmd(String messageName, String executionId, boolean async) {
        super(executionId);
        this.messageName = messageName;
        this.payload = null;
        this.async = async;
    }

    @Override
    protected Void execute(CommandContext commandContext, ExecutionEntity execution) {
        if (this.messageName == null) {
            throw new ActivitiIllegalArgumentException("messageName cannot be null");
        }
        if (Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
            activiti5CompatibilityHandler.messageEventReceived(this.messageName, this.executionId, this.payload, this.async);
            return null;
        }
        EventSubscriptionEntityManager eventSubscriptionEntityManager = commandContext.getEventSubscriptionEntityManager();
        List<EventSubscriptionEntity> eventSubscriptions = eventSubscriptionEntityManager.findEventSubscriptionsByNameAndExecution("message", this.messageName, this.executionId);
        if (eventSubscriptions.isEmpty()) {
            throw new ActivitiException("Execution with id '" + this.executionId + "' does not have a subscription to a message event with name '" + this.messageName + "'");
        }
        EventSubscriptionEntity eventSubscriptionEntity = eventSubscriptions.get(0);
        eventSubscriptionEntityManager.eventReceived(eventSubscriptionEntity, this.payload, this.async);
        return null;
    }
}

