/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.interceptor;

import org.activiti.engine.impl.cfg.TransactionContext;
import org.activiti.engine.impl.cfg.TransactionContextFactory;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.AbstractCommandInterceptor;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.TransactionCommandContextCloseListener;

public class TransactionContextInterceptor
extends AbstractCommandInterceptor {
    protected TransactionContextFactory transactionContextFactory;

    public TransactionContextInterceptor() {
    }

    public TransactionContextInterceptor(TransactionContextFactory transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CommandConfig config, Command<T> command) {
        CommandContext commandContext = Context.getCommandContext();
        boolean isReused = commandContext.isReused();
        try {
            if (this.transactionContextFactory != null && !isReused) {
                TransactionContext transactionContext = this.transactionContextFactory.openTransactionContext(commandContext);
                Context.setTransactionContext(transactionContext);
                commandContext.addCloseListener(new TransactionCommandContextCloseListener(transactionContext));
            }
            T t = this.next.execute(config, command);
            return t;
        }
        finally {
            if (this.transactionContextFactory != null && !isReused) {
                Context.removeTransactionContext();
            }
        }
    }

    public TransactionContextFactory getTransactionContextFactory() {
        return this.transactionContextFactory;
    }

    public void setTransactionContextFactory(TransactionContextFactory transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
    }
}

