/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.debug;

import java.util.Iterator;
import java.util.LinkedList;
import org.activiti.engine.debug.ExecutionTreeNode;

public class ExecutionTreeBfsIterator
implements Iterator<ExecutionTreeNode> {
    protected ExecutionTreeNode rootNode;
    protected boolean reverseOrder;
    protected LinkedList<ExecutionTreeNode> flattenedList;
    protected Iterator<ExecutionTreeNode> flattenedListIterator;

    public ExecutionTreeBfsIterator(ExecutionTreeNode executionTree) {
        this(executionTree, false);
    }

    public ExecutionTreeBfsIterator(ExecutionTreeNode rootNode, boolean reverseOrder) {
        this.rootNode = rootNode;
        this.reverseOrder = reverseOrder;
    }

    protected void flattenTree() {
        this.flattenedList = new LinkedList();
        LinkedList<ExecutionTreeNode> nodesToHandle = new LinkedList<ExecutionTreeNode>();
        nodesToHandle.add(this.rootNode);
        while (!nodesToHandle.isEmpty()) {
            ExecutionTreeNode currentNode = (ExecutionTreeNode)nodesToHandle.pop();
            if (this.reverseOrder) {
                this.flattenedList.addFirst(currentNode);
            } else {
                this.flattenedList.add(currentNode);
            }
            if (currentNode.getChildren() == null || currentNode.getChildren().size() <= 0) continue;
            for (ExecutionTreeNode childNode : currentNode.getChildren()) {
                nodesToHandle.add(childNode);
            }
        }
        this.flattenedListIterator = this.flattenedList.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.flattenedList == null) {
            this.flattenTree();
        }
        return this.flattenedListIterator.hasNext();
    }

    @Override
    public ExecutionTreeNode next() {
        if (this.flattenedList == null) {
            this.flattenTree();
        }
        return this.flattenedListIterator.next();
    }

    @Override
    public void remove() {
        if (this.flattenedList == null) {
            this.flattenTree();
        }
        this.flattenedListIterator.remove();
    }
}

