/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.CommentEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.util.Activiti5Util;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;

public class DeleteCommentCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String processInstanceId;
    protected String commentId;

    public DeleteCommentCmd(String taskId, String processInstanceId, String commentId) {
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.commentId = commentId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        CommentEntityManager commentManager = commandContext.getCommentEntityManager();
        if (this.commentId != null) {
            Task task;
            Comment comment = commentManager.findComment(this.commentId);
            if (comment == null) {
                throw new ActivitiObjectNotFoundException("Comment with id '" + this.commentId + "' doesn't exists.", Comment.class);
            }
            if (comment.getProcessInstanceId() != null) {
                ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(comment.getProcessInstanceId());
                if (execution != null && Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
                    Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
                    activiti5CompatibilityHandler.deleteComment(this.commentId, this.taskId, this.processInstanceId);
                    return null;
                }
            } else if (comment.getTaskId() != null && (task = (Task)commandContext.getTaskEntityManager().findById(comment.getTaskId())) != null && task.getProcessDefinitionId() != null && Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
                Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
                activiti5CompatibilityHandler.deleteComment(this.commentId, this.taskId, this.processInstanceId);
                return null;
            }
            commentManager.delete((CommentEntity)comment);
        } else {
            ArrayList<Comment> comments = new ArrayList<Comment>();
            if (this.processInstanceId != null) {
                ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.processInstanceId);
                if (execution != null && Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
                    Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
                    activiti5CompatibilityHandler.deleteComment(this.commentId, this.taskId, this.processInstanceId);
                    return null;
                }
                comments.addAll(commentManager.findCommentsByProcessInstanceId(this.processInstanceId));
            }
            if (this.taskId != null) {
                Task task = (Task)commandContext.getTaskEntityManager().findById(this.taskId);
                if (task != null && task.getProcessDefinitionId() != null && Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
                    Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
                    activiti5CompatibilityHandler.deleteComment(this.commentId, this.taskId, this.processInstanceId);
                    return null;
                }
                comments.addAll(commentManager.findCommentsByTaskId(this.taskId));
            }
            for (Comment comment : comments) {
                commentManager.delete((CommentEntity)comment);
            }
        }
        return null;
    }
}

