/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventDispatcher;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.calendar.DurationHelper;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.AbstractJobEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRetryCmd
implements Command<Object> {
    private static final Logger log = LoggerFactory.getLogger((String)JobRetryCmd.class.getName());
    protected String jobId;
    protected Throwable exception;

    public JobRetryCmd(String jobId, Throwable exception) {
        this.jobId = jobId;
        this.exception = exception;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        ActivitiEventDispatcher eventDispatcher;
        JobEntity job = (JobEntity)commandContext.getJobEntityManager().findById(this.jobId);
        if (job == null) {
            return null;
        }
        ProcessEngineConfigurationImpl processEngineConfig = commandContext.getProcessEngineConfiguration();
        ExecutionEntity executionEntity = this.fetchExecutionEntity(commandContext, job.getExecutionId());
        FlowElement currentFlowElement = executionEntity != null ? executionEntity.getCurrentFlowElement() : null;
        String failedJobRetryTimeCycleValue = null;
        if (currentFlowElement instanceof ServiceTask) {
            failedJobRetryTimeCycleValue = ((ServiceTask)currentFlowElement).getFailedJobRetryTimeCycleValue();
        }
        AbstractJobEntity newJobEntity = null;
        if (currentFlowElement == null || failedJobRetryTimeCycleValue == null) {
            log.debug("activity or FailedJobRetryTimerCycleValue is null in job " + this.jobId + ". only decrementing retries.");
            newJobEntity = job.getRetries() <= 1 ? commandContext.getJobManager().moveJobToDeadLetterJob(job) : commandContext.getJobManager().moveJobToTimerJob(job);
            newJobEntity.setRetries(job.getRetries() - 1);
            if (job.getDuedate() == null || "message".equals(job.getJobType())) {
                newJobEntity.setDuedate(this.calculateDueDate(commandContext, processEngineConfig.getAsyncFailedJobWaitTime(), null));
            } else {
                newJobEntity.setDuedate(this.calculateDueDate(commandContext, processEngineConfig.getDefaultFailedJobWaitTime(), job.getDuedate()));
            }
        } else {
            try {
                DurationHelper durationHelper = new DurationHelper(failedJobRetryTimeCycleValue, processEngineConfig.getClock());
                int jobRetries = job.getRetries();
                if (job.getExceptionMessage() == null) {
                    jobRetries = durationHelper.getTimes();
                }
                newJobEntity = jobRetries <= 1 ? commandContext.getJobManager().moveJobToDeadLetterJob(job) : commandContext.getJobManager().moveJobToTimerJob(job);
                newJobEntity.setDuedate(durationHelper.getDateAfter());
                if (job.getExceptionMessage() == null) {
                    log.debug("Applying JobRetryStrategy '" + failedJobRetryTimeCycleValue + "' the first time for job " + job.getId() + " with " + durationHelper.getTimes() + " retries");
                } else {
                    log.debug("Decrementing retries of JobRetryStrategy '" + failedJobRetryTimeCycleValue + "' for job " + job.getId());
                }
                newJobEntity.setRetries(jobRetries - 1);
            }
            catch (Exception e) {
                throw new ActivitiException("failedJobRetryTimeCylcle has wrong format:" + failedJobRetryTimeCycleValue, this.exception);
            }
        }
        if (this.exception != null) {
            newJobEntity.setExceptionMessage(this.exception.getMessage());
            newJobEntity.setExceptionStacktrace(this.getExceptionStacktrace());
        }
        if ((eventDispatcher = commandContext.getEventDispatcher()).isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, newJobEntity));
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_RETRIES_DECREMENTED, newJobEntity));
        }
        return null;
    }

    protected Date calculateDueDate(CommandContext commandContext, int waitTimeInSeconds, Date oldDate) {
        GregorianCalendar newDateCal = new GregorianCalendar();
        if (oldDate != null) {
            newDateCal.setTime(oldDate);
        } else {
            newDateCal.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        }
        ((Calendar)newDateCal).add(13, waitTimeInSeconds);
        return newDateCal.getTime();
    }

    protected String getExceptionStacktrace() {
        StringWriter stringWriter = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    protected ExecutionEntity fetchExecutionEntity(CommandContext commandContext, String executionId) {
        if (executionId == null) {
            return null;
        }
        return (ExecutionEntity)commandContext.getExecutionEntityManager().findById(executionId);
    }
}

