/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.listener;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.invocation.TaskListenerInvocation;

public class DelegateExpressionTaskListener
implements TaskListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionTaskListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void notify(DelegateTask delegateTask) {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, delegateTask, this.fieldDeclarations);
        if (delegate instanceof TaskListener) {
            try {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation((TaskListener)delegate, delegateTask));
            }
            catch (Exception e) {
                throw new ActivitiException("Exception while invoking TaskListener: " + e.getMessage(), e);
            }
        } else {
            throw new ActivitiIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + TaskListener.class);
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

