/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.api.internal.Internal;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.AttachmentEntity;
import org.activiti.engine.impl.persistence.entity.AttachmentEntityManager;
import org.activiti.engine.impl.persistence.entity.data.AttachmentDataManager;
import org.activiti.engine.impl.persistence.entity.data.DataManager;
import org.activiti.engine.task.Attachment;
import org.activiti.engine.task.Task;

@Internal
@Deprecated
public class AttachmentEntityManagerImpl
extends AbstractEntityManager<AttachmentEntity>
implements AttachmentEntityManager {
    protected AttachmentDataManager attachmentDataManager;

    public AttachmentEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, AttachmentDataManager attachmentDataManager) {
        super(processEngineConfiguration);
        this.attachmentDataManager = attachmentDataManager;
    }

    @Override
    protected DataManager<AttachmentEntity> getDataManager() {
        return this.attachmentDataManager;
    }

    @Override
    public List<AttachmentEntity> findAttachmentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.attachmentDataManager.findAttachmentsByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<AttachmentEntity> findAttachmentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.attachmentDataManager.findAttachmentsByTaskId(taskId);
    }

    @Override
    public void deleteAttachmentsByTaskId(String taskId) {
        Task task;
        this.checkHistoryEnabled();
        List<AttachmentEntity> attachments = this.findAttachmentsByTaskId(taskId);
        boolean dispatchEvents = this.getEventDispatcher().isEnabled();
        String processInstanceId = null;
        String processDefinitionId = null;
        String executionId = null;
        if (dispatchEvents && attachments != null && !attachments.isEmpty() && (task = (Task)this.getTaskEntityManager().findById(taskId)) != null) {
            processDefinitionId = task.getProcessDefinitionId();
            processInstanceId = task.getProcessInstanceId();
            executionId = task.getExecutionId();
        }
        for (Attachment attachment : attachments) {
            String contentId = attachment.getContentId();
            if (contentId != null) {
                this.getByteArrayEntityManager().deleteByteArrayById(contentId);
            }
            this.attachmentDataManager.delete((AttachmentEntity)attachment);
            if (!dispatchEvents) continue;
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, attachment, executionId, processInstanceId, processDefinitionId));
        }
    }

    protected void checkHistoryEnabled() {
        if (!this.getHistoryManager().isHistoryEnabled()) {
            throw new ActivitiException("In order to use attachments, history should be enabled");
        }
    }

    public AttachmentDataManager getAttachmentDataManager() {
        return this.attachmentDataManager;
    }

    public void setAttachmentDataManager(AttachmentDataManager attachmentDataManager) {
        this.attachmentDataManager = attachmentDataManager;
    }
}

