/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.JobNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.FailedJobListener;
import org.activiti.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ExecuteJobCmd.class);
    protected String jobId;

    public ExecuteJobCmd(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new ActivitiIllegalArgumentException("jobId and job is null");
        }
        Job job = (Job)commandContext.getJobEntityManager().findById(this.jobId);
        if (job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        if (log.isDebugEnabled()) {
            log.debug("Executing job {}", (Object)job.getId());
        }
        commandContext.addCloseListener(new FailedJobListener(commandContext.getProcessEngineConfiguration().getCommandExecutor(), job));
        try {
            commandContext.getJobManager().execute(job);
        }
        catch (Throwable exception) {
            throw new ActivitiException("Job " + this.jobId + " failed", exception);
        }
        return null;
    }

    public String getJobId() {
        return this.jobId;
    }
}

