/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.form;

import com.vaadin.data.Validator;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Form;
import com.vaadin.ui.VerticalLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.form.FormType;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.ui.form.FormPropertyRenderer;
import org.activiti.explorer.ui.form.FormPropertyRendererManager;

public class FormPropertiesComponent
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    protected FormPropertyRendererManager formPropertyRendererManager = ExplorerApp.get().getFormPropertyRendererManager();
    protected List<FormProperty> formProperties;
    protected Map<FormProperty, Component> propertyComponents;
    protected Form form;

    public FormPropertiesComponent() {
        this.setSizeFull();
        this.initForm();
    }

    public List<FormProperty> getFormProperties() {
        return this.formProperties;
    }

    public void setFormProperties(List<FormProperty> formProperties) {
        this.formProperties = formProperties;
        this.form.removeAllProperties();
        if (formProperties != null) {
            for (FormProperty formProperty : formProperties) {
                FormPropertyRenderer renderer = this.getRenderer(formProperty);
                Field editorComponent = renderer.getPropertyField(formProperty);
                if (editorComponent == null) continue;
                this.form.addField((Object)formProperty.getId(), editorComponent);
            }
        }
    }

    public Map<String, String> getFormPropertyValues() throws Validator.InvalidValueException {
        this.form.commit();
        HashMap<String, String> formPropertyValues = new HashMap<String, String>();
        for (FormProperty formProperty : this.formProperties) {
            if (!formProperty.isWritable()) continue;
            Field field = this.form.getField((Object)formProperty.getId());
            FormPropertyRenderer renderer = this.getRenderer(formProperty);
            String fieldValue = renderer.getFieldValue(formProperty, field);
            formPropertyValues.put(formProperty.getId(), fieldValue);
        }
        return formPropertyValues;
    }

    public void setFormEnabled(boolean enabled) {
        if (enabled) {
            this.form.setEnabled(enabled);
        }
    }

    protected void initForm() {
        this.form = new Form();
        this.form.setSizeFull();
        this.addComponent((Component)this.form);
        this.setComponentAlignment((Component)this.form, Alignment.TOP_CENTER);
    }

    protected FormPropertyRenderer getRenderer(FormProperty formProperty) {
        FormType formPropertyType = formProperty.getType();
        if (formPropertyType == null) {
            return this.formPropertyRendererManager.getTypeLessFormPropertyRenderer();
        }
        return this.formPropertyRendererManager.getPropertyRendererForType(formProperty.getType());
    }
}

