/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.identity;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.activiti.explorer.identity.LoggedInUser;

public class LoggedInUserImpl
implements LoggedInUser {
    private static final long serialVersionUID = 1L;
    protected User user;
    protected String password;
    protected String alternativeId;
    protected boolean isUser;
    protected boolean isAdmin;
    protected List<Group> securityRoles = new ArrayList<Group>();
    protected List<Group> groups = new ArrayList<Group>();

    public LoggedInUserImpl(User user, String password) {
        this.user = user;
        this.password = password;
    }

    @Override
    public String getId() {
        if (this.user != null) {
            return this.user.getId();
        }
        return this.alternativeId;
    }

    @Override
    public String getFirstName() {
        if (this.user != null) {
            return this.user.getFirstName();
        }
        return null;
    }

    @Override
    public String getLastName() {
        if (this.user != null) {
            return this.user.getLastName();
        }
        return null;
    }

    @Override
    public String getFullName() {
        if (this.user != null) {
            return this.getFirstName() + " " + this.getLastName();
        }
        return null;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.user.setPassword(password);
        this.password = password;
    }

    @Override
    public boolean isUser() {
        return this.isUser;
    }

    public void setUser(boolean isUser) {
        this.isUser = isUser;
    }

    @Override
    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void addSecurityRoleGroup(Group securityRoleGroup) {
        this.securityRoles.add(securityRoleGroup);
    }

    @Override
    public List<Group> getSecurityRoles() {
        return this.securityRoles;
    }

    @Override
    public List<Group> getGroups() {
        return this.groups;
    }

    public void addGroup(Group group) {
        this.groups.add(group);
    }
}

