/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.alfresco;

import com.vaadin.data.Property;
import com.vaadin.data.util.ObjectProperty;
import com.vaadin.data.util.PropertysetItem;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.ui.Images;

class AlfrescoProcessInstanceTableItem
extends PropertysetItem
implements Comparable<AlfrescoProcessInstanceTableItem> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_BUSINESSKEY = "businessKey";
    public static final String PROPERTY_ACTIONS = "actions";

    public AlfrescoProcessInstanceTableItem(final ProcessInstance processInstance) {
        this.addItemProperty(PROPERTY_ID, (Property)new ObjectProperty((Object)processInstance.getId(), String.class));
        if (processInstance.getBusinessKey() != null) {
            this.addItemProperty(PROPERTY_BUSINESSKEY, (Property)new ObjectProperty((Object)processInstance.getBusinessKey(), String.class));
        }
        Button viewProcessInstanceButton = new Button(ExplorerApp.get().getI18nManager().getMessage("process.action.view"));
        viewProcessInstanceButton.addStyleName("link");
        viewProcessInstanceButton.addListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                ExplorerApp.get().getViewManager().showProcessInstancePage(processInstance.getId());
            }
        });
        viewProcessInstanceButton.setIcon(Images.MAGNIFIER_16);
        this.addItemProperty(PROPERTY_ACTIONS, (Property)new ObjectProperty((Object)viewProcessInstanceButton, Component.class));
    }

    @Override
    public int compareTo(AlfrescoProcessInstanceTableItem other) {
        String id = (String)this.getItemProperty(PROPERTY_ID).getValue();
        String otherId = (String)other.getItemProperty(PROPERTY_ID).getValue();
        return id.compareTo(otherId);
    }
}

