/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.reports;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.ui.Component;
import com.vaadin.ui.Table;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.data.LazyLoadingContainer;
import org.activiti.explorer.data.LazyLoadingQuery;
import org.activiti.explorer.navigation.UriFragment;
import org.activiti.explorer.ui.AbstractTablePage;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.ToolBar;
import org.activiti.explorer.ui.reports.ReportDetailPanel;
import org.activiti.explorer.ui.reports.ReportListQuery;
import org.activiti.explorer.ui.reports.ReportsMenuBar;
import org.activiti.explorer.ui.util.ThemeImageColumnGenerator;

public class RunReportsPage
extends AbstractTablePage {
    private static final long serialVersionUID = -5259331126409002997L;
    protected String reportId;
    protected Table reportTable;
    protected LazyLoadingQuery reportListQuery;
    protected LazyLoadingContainer reportListContainer;

    public RunReportsPage(String reportId) {
        this.reportId = reportId;
    }

    public RunReportsPage() {
        this(null);
    }

    @Override
    protected Table createList() {
        this.reportTable = new Table();
        this.reportListQuery = new ReportListQuery();
        this.reportListContainer = new LazyLoadingContainer(this.reportListQuery);
        this.reportTable.setContainerDataSource((Container)this.reportListContainer);
        this.reportTable.addGeneratedColumn((Object)"icon", (Table.ColumnGenerator)new ThemeImageColumnGenerator(Images.REPORT_22));
        this.reportTable.setColumnWidth((Object)"icon", 22);
        this.reportTable.addContainerProperty((Object)"name", String.class, null);
        this.reportTable.setColumnHeaderMode(-1);
        this.reportTable.addListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                Item item = RunReportsPage.this.reportTable.getItem(event.getProperty().getValue());
                if (item != null) {
                    String processDefinitionId = (String)item.getItemProperty((Object)"id").getValue();
                    RunReportsPage.this.setDetailComponent((Component)new ReportDetailPanel(processDefinitionId, RunReportsPage.this));
                    ExplorerApp.get().setCurrentUriFragment(new UriFragment("report", processDefinitionId));
                } else {
                    RunReportsPage.this.setDetailComponent(null);
                    ExplorerApp.get().setCurrentUriFragment(new UriFragment("report"));
                }
            }
        });
        return this.reportTable;
    }

    @Override
    protected ToolBar createMenuBar() {
        return new ReportsMenuBar();
    }

    @Override
    protected void initUi() {
        super.initUi();
        if (this.reportId != null) {
            this.selectElement(this.reportListContainer.getIndexForObjectId(this.reportId));
        } else {
            this.selectElement(0);
        }
    }
}

