/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.deployment;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.ObjectProperty;
import com.vaadin.data.util.PropertysetItem;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;
import org.activiti.explorer.ui.management.deployment.DeploymentFilter;

public class DeploymentListQuery
extends AbstractLazyLoadingQuery {
    protected transient RepositoryService repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
    protected DeploymentFilter deploymentFilter;

    public DeploymentListQuery(DeploymentFilter deploymentFilter) {
        this.deploymentFilter = deploymentFilter;
    }

    @Override
    public int size() {
        return (int)this.deploymentFilter.getCountQuery(this.repositoryService).count();
    }

    @Override
    public List<Item> loadItems(int start, int count) {
        List deployments = this.deploymentFilter.getQuery(this.repositoryService).listPage(start, count);
        ArrayList<Item> items = new ArrayList<Item>();
        for (Deployment deployment : deployments) {
            items.add((Item)this.deploymentFilter.createItem(deployment));
        }
        return items;
    }

    @Override
    public Item loadSingleResult(String id) {
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(id).singleResult();
        if (deployment != null) {
            return this.deploymentFilter.createItem(deployment);
        }
        return null;
    }

    @Override
    public void setSorting(Object[] propertyIds, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }

    public static class DeploymentListitem
    extends PropertysetItem
    implements Comparable<DeploymentListitem> {
        private static final long serialVersionUID = 1L;

        public DeploymentListitem(Deployment deployment) {
            this.addItemProperty("id", (Property)new ObjectProperty((Object)deployment.getId(), String.class));
            if (deployment.getName() != null) {
                this.addItemProperty("name", (Property)new ObjectProperty((Object)deployment.getName(), String.class));
            } else {
                this.addItemProperty("name", (Property)new ObjectProperty((Object)ExplorerApp.get().getI18nManager().getMessage("deployment.no.name"), String.class));
            }
        }

        @Override
        public int compareTo(DeploymentListitem other) {
            String otherName;
            String name = (String)this.getItemProperty("name").getValue();
            int comparison = name.compareTo(otherName = (String)other.getItemProperty("name").getValue());
            if (comparison != 0) {
                return comparison;
            }
            String id = (String)this.getItemProperty("id").getValue();
            String otherId = (String)other.getItemProperty("id").getValue();
            return id.compareTo(otherId);
        }
    }
}

