/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.ObjectProperty;
import com.vaadin.data.util.PropertysetItem;
import com.vaadin.event.MouseEvents;
import com.vaadin.ui.Button;
import com.vaadin.ui.Embedded;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.management.identity.DeleteMembershipListener;
import org.activiti.explorer.ui.management.identity.MemberShipChangeListener;

public class GroupMembersQuery
extends AbstractLazyLoadingQuery {
    protected transient IdentityService identityService;
    protected String groupId;
    protected MemberShipChangeListener memberShipChangeListener;
    protected String sortby;
    protected boolean ascending;

    public GroupMembersQuery(String groupId, MemberShipChangeListener memberShipChangeListener) {
        this.groupId = groupId;
        this.memberShipChangeListener = memberShipChangeListener;
        this.identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
    }

    @Override
    public int size() {
        return (int)this.identityService.createUserQuery().memberOfGroup(this.groupId).count();
    }

    @Override
    public List<Item> loadItems(int start, int count) {
        UserQuery query = this.identityService.createUserQuery().memberOfGroup(this.groupId);
        if (this.sortby == null || "id".equals(this.sortby)) {
            query.orderByUserId();
        } else if ("firstName".equals(this.sortby)) {
            query.orderByUserFirstName();
        } else if ("lastName".equals(this.sortby)) {
            query.orderByUserLastName();
        } else if ("email".equals(this.sortby)) {
            query.orderByUserEmail();
        }
        if (this.sortby == null || this.ascending) {
            query.asc();
        } else {
            query.desc();
        }
        List users = query.listPage(start, count);
        ArrayList<Item> items = new ArrayList<Item>();
        for (User user : users) {
            items.add((Item)new GroupMemberItem(user));
        }
        return items;
    }

    @Override
    public Item loadSingleResult(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSorting(Object[] propertyIds, boolean[] ascending) {
        if (propertyIds.length > 0) {
            this.sortby = propertyIds[0].toString();
            this.ascending = ascending[0];
        }
    }

    class GroupMemberItem
    extends PropertysetItem {
        private static final long serialVersionUID = 1L;

        public GroupMemberItem(final User user) {
            Button idButton = new Button(user.getId());
            idButton.addStyleName("link");
            idButton.addListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    ExplorerApp.get().getViewManager().showUserPage(user.getId());
                }
            });
            this.addItemProperty("id", (Property)new ObjectProperty((Object)idButton, Button.class));
            if (user.getFirstName() != null) {
                this.addItemProperty("firstName", (Property)new ObjectProperty((Object)user.getFirstName(), String.class));
            }
            if (user.getLastName() != null) {
                this.addItemProperty("lastName", (Property)new ObjectProperty((Object)user.getLastName(), String.class));
            }
            if (user.getEmail() != null) {
                this.addItemProperty("email", (Property)new ObjectProperty((Object)user.getEmail(), String.class));
            }
            Embedded deleteIcon = new Embedded(null, Images.DELETE);
            deleteIcon.addStyleName("clickable");
            deleteIcon.addListener((MouseEvents.ClickListener)new DeleteMembershipListener(GroupMembersQuery.this.identityService, user.getId(), GroupMembersQuery.this.groupId, GroupMembersQuery.this.memberShipChangeListener));
            this.addItemProperty("actions", (Property)new ObjectProperty((Object)deleteIcon, Embedded.class));
        }
    }
}

