/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.ObjectProperty;
import com.vaadin.data.util.PropertysetItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;

public class GroupSelectionQuery
extends AbstractLazyLoadingQuery {
    protected transient IdentityService identityService;
    protected String userId;

    public GroupSelectionQuery(IdentityService identityService, String userId) {
        this.identityService = identityService;
        this.userId = userId;
    }

    @Override
    public int size() {
        return (int)(this.identityService.createGroupQuery().count() - this.identityService.createGroupQuery().groupMember(this.userId).count());
    }

    @Override
    public List<Item> loadItems(int start, int count) {
        ArrayList<Item> groupItems = new ArrayList<Item>();
        Set<String> currentGroups = this.getCurrentGroups();
        int nrFound = 0;
        for (int tries = 0; nrFound < count && tries < 5; ++tries) {
            List groups = ((GroupQuery)((GroupQuery)((GroupQuery)this.identityService.createGroupQuery().orderByGroupType().asc()).orderByGroupId().asc()).orderByGroupName().asc()).listPage(start + tries * count, count);
            for (Group group : groups) {
                if (currentGroups.contains(group.getId())) continue;
                ++nrFound;
                groupItems.add((Item)new GroupSelectionItem(group));
            }
        }
        return groupItems;
    }

    protected Set<String> getCurrentGroups() {
        HashSet<String> groupIds = new HashSet<String>();
        List currentGroups = this.identityService.createGroupQuery().groupMember(this.userId).list();
        for (Group group : currentGroups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    @Override
    public Item loadSingleResult(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSorting(Object[] propertyIds, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }

    class GroupSelectionItem
    extends PropertysetItem {
        private static final long serialVersionUID = 1L;

        public GroupSelectionItem(Group group) {
            this.addItemProperty("id", (Property)new ObjectProperty((Object)group.getId(), String.class));
            if (group.getName() != null) {
                this.addItemProperty("name", (Property)new ObjectProperty((Object)group.getName(), String.class));
            }
            if (group.getType() != null) {
                this.addItemProperty("type", (Property)new ObjectProperty((Object)group.getType(), String.class));
            }
        }
    }
}

