/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task;

import com.vaadin.Application;
import com.vaadin.event.Action;
import com.vaadin.event.ShortcutAction;
import com.vaadin.terminal.Resource;
import com.vaadin.terminal.StreamResource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.io.InputStream;
import java.util.List;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.identity.Picture;
import org.activiti.engine.task.Event;
import org.activiti.explorer.Constants;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.task.TaskEventTextResolver;
import org.activiti.explorer.util.time.HumanTime;

public class TaskEventsPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    protected transient IdentityService identityService;
    protected transient TaskService taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
    protected I18nManager i18nManager;
    protected ViewManager viewManager;
    protected TaskEventTextResolver taskEventTextResolver;
    protected String taskId;
    protected List<Event> taskEvents;
    protected TextField commentInputField;
    protected Button addCommentButton;
    protected GridLayout eventGrid;

    public TaskEventsPanel() {
        this.identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.viewManager = ExplorerApp.get().getViewManager();
        this.taskEventTextResolver = new TaskEventTextResolver();
        ((VerticalLayout)this.getContent()).setSpacing(true);
        ((VerticalLayout)this.getContent()).setMargin(true);
        this.setHeight(100.0f, 8);
        this.addStyleName("task-event-panel");
        this.addTitle();
        this.addInputField();
        this.initEventGrid();
        this.addTaskEvents();
    }

    public void refreshTaskEvents() {
        this.eventGrid.removeAllComponents();
        this.addTaskEvents();
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
        this.refreshTaskEvents();
    }

    protected void addTitle() {
        Label eventTitle = new Label(this.i18nManager.getMessage("event.title"));
        eventTitle.addStyleName("h2");
        this.addComponent((Component)eventTitle);
    }

    protected void initEventGrid() {
        this.eventGrid = new GridLayout();
        this.eventGrid.setColumns(2);
        this.eventGrid.setSpacing(true);
        this.eventGrid.setMargin(true, false, false, false);
        this.eventGrid.setWidth("100%");
        this.eventGrid.setColumnExpandRatio(1, 1.0f);
        this.eventGrid.addStyleName("event-grid");
        this.addComponent((Component)this.eventGrid);
    }

    protected void addTaskEvents() {
        if (this.taskId != null) {
            this.taskEvents = this.taskService.getTaskEvents(this.taskId);
            for (Event event : this.taskEvents) {
                this.addTaskEventPicture(event, this.eventGrid);
                this.addTaskEventText(event, this.eventGrid);
            }
        }
        this.addCommentButton.setEnabled(this.taskId != null);
        this.commentInputField.setEnabled(this.taskId != null);
    }

    protected void addTaskEventPicture(Event taskEvent, GridLayout eventGrid) {
        final Picture userPicture = this.identityService.getUserPicture(taskEvent.getUserId());
        Embedded authorPicture = null;
        if (userPicture != null) {
            StreamResource imageresource = new StreamResource(new StreamResource.StreamSource(){
                private static final long serialVersionUID = 1L;

                public InputStream getStream() {
                    return userPicture.getInputStream();
                }
            }, "event_" + taskEvent.getUserId() + "." + Constants.MIMETYPE_EXTENSION_MAPPING.get(userPicture.getMimeType()), (Application)ExplorerApp.get());
            authorPicture = new Embedded(null, (Resource)imageresource);
        } else {
            authorPicture = new Embedded(null, Images.USER_50);
        }
        authorPicture.setType(1);
        authorPicture.setHeight("48px");
        authorPicture.setWidth("48px");
        authorPicture.addStyleName("task-event-picture");
        eventGrid.addComponent((Component)authorPicture);
    }

    protected void addTaskEventText(Event taskEvent, GridLayout eventGrid) {
        VerticalLayout layout = new VerticalLayout();
        layout.addStyleName("task-event");
        layout.setWidth("100%");
        eventGrid.addComponent((Component)layout);
        Label text = this.taskEventTextResolver.resolveText(taskEvent);
        text.setWidth("100%");
        layout.addComponent((Component)text);
        Label time = new Label(new HumanTime(this.i18nManager).format(taskEvent.getTime()));
        time.setSizeUndefined();
        time.addStyleName("task-event-time");
        layout.addComponent((Component)time);
    }

    protected void addInputField() {
        HorizontalLayout layout = new HorizontalLayout();
        layout.setSpacing(true);
        layout.setWidth(100.0f, 8);
        this.addComponent((Component)layout);
        Panel textFieldPanel = new Panel();
        textFieldPanel.addStyleName("light");
        textFieldPanel.setContent((ComponentContainer)new VerticalLayout());
        textFieldPanel.setWidth(100.0f, 8);
        layout.addComponent((Component)textFieldPanel);
        layout.setExpandRatio((Component)textFieldPanel, 1.0f);
        this.commentInputField = new TextField();
        this.commentInputField.setWidth(100.0f, 8);
        textFieldPanel.addComponent((Component)this.commentInputField);
        textFieldPanel.addActionHandler(new Action.Handler(){

            public void handleAction(Action action, Object sender, Object target) {
                TaskEventsPanel.this.addNewComment(TaskEventsPanel.this.commentInputField.getValue().toString());
            }

            public Action[] getActions(Object target, Object sender) {
                return new Action[]{new ShortcutAction("enter", 13, null)};
            }
        });
        this.addCommentButton = new Button(this.i18nManager.getMessage("task.comment.add"));
        layout.addComponent((Component)this.addCommentButton);
        layout.setComponentAlignment((Component)this.addCommentButton, Alignment.MIDDLE_LEFT);
        this.addCommentButton.addListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                TaskEventsPanel.this.addNewComment(TaskEventsPanel.this.commentInputField.getValue().toString());
            }
        });
    }

    protected void addNewComment(String text) {
        this.taskService.addComment(this.taskId, null, text);
        this.refreshTaskEvents();
        this.commentInputField.setValue((Object)"");
        this.commentInputField.focus();
    }
}

