/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task;

import com.vaadin.ui.Button;
import java.util.List;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.Group;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.identity.LoggedInUser;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.ToolBar;
import org.activiti.explorer.ui.custom.ToolbarEntry;
import org.activiti.explorer.ui.custom.ToolbarPopupEntry;
import org.activiti.explorer.ui.task.NewCasePopupWindow;
import org.activiti.explorer.ui.task.data.ArchivedListQuery;
import org.activiti.explorer.ui.task.data.InboxListQuery;
import org.activiti.explorer.ui.task.data.InvolvedListQuery;
import org.activiti.explorer.ui.task.data.QueuedListQuery;
import org.activiti.explorer.ui.task.data.TasksListQuery;

public class TaskMenuBar
extends ToolBar {
    private static final long serialVersionUID = 1L;
    public static final String ENTRY_TASKS = "tasks";
    public static final String ENTRY_INBOX = "inbox";
    public static final String ENTRY_QUEUED = "queued";
    public static final String ENTRY_INVOLVED = "involved";
    public static final String ENTRY_ARCHIVED = "archived";
    protected transient IdentityService identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
    protected ViewManager viewManager = ExplorerApp.get().getViewManager();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();

    public TaskMenuBar() {
        this.initItems();
        this.initActions();
    }

    protected void initItems() {
        this.setWidth("100%");
        long inboxCount = new InboxListQuery().size();
        ToolbarEntry inboxEntry = this.addToolbarEntry(ENTRY_INBOX, this.i18nManager.getMessage("task.menu.inbox"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                TaskMenuBar.this.viewManager.showInboxPage();
            }
        });
        inboxEntry.setCount(inboxCount);
        LoggedInUser user = ExplorerApp.get().getLoggedInUser();
        long tasksCount = new TasksListQuery().size();
        ToolbarEntry tasksEntry = this.addToolbarEntry(ENTRY_TASKS, this.i18nManager.getMessage("task.menu.tasks"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                TaskMenuBar.this.viewManager.showTasksPage();
            }
        });
        tasksEntry.setCount(tasksCount);
        List<Group> groups = user.getGroups();
        ToolbarPopupEntry queuedItem = this.addPopupEntry(ENTRY_QUEUED, this.i18nManager.getMessage("task.menu.queued"));
        long queuedCount = 0L;
        for (final Group group : groups) {
            long groupCount = new QueuedListQuery(group.getId()).size();
            queuedItem.addMenuItem(group.getName() + " (" + groupCount + ")", new ToolbarEntry.ToolbarCommand(){

                @Override
                public void toolBarItemSelected() {
                    TaskMenuBar.this.viewManager.showQueuedPage(group.getId());
                }
            });
            queuedCount += groupCount;
        }
        queuedItem.setCount(queuedCount);
        long involvedCount = new InvolvedListQuery().size();
        ToolbarEntry involvedEntry = this.addToolbarEntry(ENTRY_INVOLVED, this.i18nManager.getMessage("task.menu.involved"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                TaskMenuBar.this.viewManager.showInvolvedPage();
            }
        });
        involvedEntry.setCount(involvedCount);
        long archivedCount = new ArchivedListQuery().size();
        ToolbarEntry archivedEntry = this.addToolbarEntry(ENTRY_ARCHIVED, this.i18nManager.getMessage("task.menu.archived"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                TaskMenuBar.this.viewManager.showArchivedPage();
            }
        });
        archivedEntry.setCount(archivedCount);
    }

    protected void initActions() {
        Button newCaseButton = new Button();
        newCaseButton.setCaption(this.i18nManager.getMessage("task.new"));
        newCaseButton.setIcon(Images.TASK_16);
        this.addButton(newCaseButton);
        newCaseButton.addListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                NewCasePopupWindow newTaskPopupWindow = new NewCasePopupWindow();
                TaskMenuBar.this.viewManager.showPopupWindow(newTaskPopupWindow);
            }
        });
    }
}

