/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.activiti.form.api.SubmittedForm;
import org.activiti.form.api.SubmittedFormQuery;
import org.activiti.form.engine.ActivitiFormIllegalArgumentException;
import org.activiti.form.engine.impl.AbstractQuery;
import org.activiti.form.engine.impl.Page;
import org.activiti.form.engine.impl.SubmittedFormQueryProperty;
import org.activiti.form.engine.impl.interceptor.CommandContext;
import org.activiti.form.engine.impl.interceptor.CommandExecutor;

public class SubmittedFormQueryImpl
extends AbstractQuery<SubmittedFormQuery, SubmittedForm>
implements SubmittedFormQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected Set<String> ids;
    protected String formId;
    protected String formIdLike;
    protected String taskId;
    protected String taskIdLike;
    protected String processInstanceId;
    protected String processInstanceIdLike;
    protected String processDefinitionId;
    protected String processDefinitionIdLike;
    protected Date submittedDate;
    protected Date submittedDateBefore;
    protected Date submittedDateAfter;
    protected String submittedBy;
    protected String submittedByLike;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;

    public SubmittedFormQueryImpl() {
    }

    public SubmittedFormQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public SubmittedFormQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public SubmittedFormQueryImpl id(String id) {
        this.id = id;
        return this;
    }

    public SubmittedFormQueryImpl ids(Set<String> ids) {
        this.ids = ids;
        return this;
    }

    public SubmittedFormQueryImpl formId(String formId) {
        this.formId = formId;
        return this;
    }

    public SubmittedFormQueryImpl formIdLike(String formIdLike) {
        this.formIdLike = formIdLike;
        return this;
    }

    public SubmittedFormQueryImpl taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public SubmittedFormQueryImpl taskIdLike(String taskIdLike) {
        this.taskIdLike = taskIdLike;
        return this;
    }

    public SubmittedFormQueryImpl processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public SubmittedFormQueryImpl processInstanceIdLike(String processInstanceIdLike) {
        this.processInstanceIdLike = processInstanceIdLike;
        return this;
    }

    public SubmittedFormQueryImpl processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public SubmittedFormQueryImpl processDefinitionIdLike(String processDefinitionIdLike) {
        this.processDefinitionIdLike = processDefinitionIdLike;
        return this;
    }

    public SubmittedFormQueryImpl submittedDate(Date submittedDate) {
        this.submittedDate = submittedDate;
        return this;
    }

    public SubmittedFormQueryImpl submittedDateBefore(Date submittedDateBefore) {
        this.submittedDateBefore = submittedDateBefore;
        return this;
    }

    public SubmittedFormQueryImpl submittedDateAfter(Date submittedDateAfter) {
        this.submittedDateAfter = submittedDateAfter;
        return this;
    }

    public SubmittedFormQueryImpl submittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
        return this;
    }

    public SubmittedFormQueryImpl submittedByLike(String submittedByLike) {
        this.submittedByLike = submittedByLike;
        return this;
    }

    public SubmittedFormQueryImpl deploymentTenantId(String tenantId) {
        if (tenantId == null) {
            throw new ActivitiFormIllegalArgumentException("deploymentTenantId is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public SubmittedFormQueryImpl deploymentTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new ActivitiFormIllegalArgumentException("deploymentTenantIdLike is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public SubmittedFormQueryImpl deploymentWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public SubmittedFormQuery orderBySubmittedDate() {
        return (SubmittedFormQuery)this.orderBy(SubmittedFormQueryProperty.SUBMITTED_DATE);
    }

    public SubmittedFormQuery orderByTenantId() {
        return (SubmittedFormQuery)this.orderBy(SubmittedFormQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getSubmittedFormEntityManager().findSubmittedFormCountByQueryCriteria(this);
    }

    @Override
    public List<SubmittedForm> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getSubmittedFormEntityManager().findSubmittedFormsByQueryCriteria(this, page);
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public String getFormId() {
        return this.formId;
    }

    public String getFormIdLike() {
        return this.formIdLike;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskIdLike() {
        return this.taskIdLike;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessInstanceIdLike() {
        return this.processInstanceIdLike;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionIdLike() {
        return this.processDefinitionIdLike;
    }

    public Date getSubmittedDate() {
        return this.submittedDate;
    }

    public Date getSubmittedDateBefore() {
        return this.submittedDateBefore;
    }

    public Date getSubmittedDateAfter() {
        return this.submittedDateAfter;
    }

    public String getSubmittedBy() {
        return this.submittedBy;
    }

    public String getSubmittedByLike() {
        return this.submittedByLike;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }
}

