/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.editor.form.converter.FormJsonConverter;
import org.activiti.form.engine.ActivitiFormObjectNotFoundException;
import org.activiti.form.engine.impl.interceptor.Command;
import org.activiti.form.engine.impl.interceptor.CommandContext;
import org.activiti.form.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.form.engine.impl.persistence.deploy.FormCacheEntry;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;
import org.activiti.form.model.FormDefinition;

public class GetFormDefinitionCmd
implements Command<FormDefinition>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String formDefinitionKey;
    protected String formId;
    protected String tenantId;
    protected String parentDeploymentId;

    public GetFormDefinitionCmd(String formDefinitionKey, String formId) {
        this.formDefinitionKey = formDefinitionKey;
        this.formId = formId;
    }

    public GetFormDefinitionCmd(String formDefinitionKey, String formId, String tenantId) {
        this(formDefinitionKey, formId);
        this.tenantId = tenantId;
    }

    public GetFormDefinitionCmd(String formDefinitionKey, String formId, String tenantId, String parentDeploymentId) {
        this(formDefinitionKey, formId, tenantId);
        this.parentDeploymentId = parentDeploymentId;
    }

    @Override
    public FormDefinition execute(CommandContext commandContext) {
        DeploymentManager deploymentManager = commandContext.getFormEngineConfiguration().getDeploymentManager();
        FormEntity formEntity = null;
        if (this.formId != null) {
            formEntity = deploymentManager.findDeployedFormById(this.formId);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for id = '" + this.formId + "'", FormEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId == null) {
            formEntity = deploymentManager.findDeployedLatestFormByKey(this.formDefinitionKey);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for key '" + this.formDefinitionKey + "'", FormEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId == null) {
            formEntity = deploymentManager.findDeployedLatestFormByKeyAndTenantId(this.formDefinitionKey, this.tenantId);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for key '" + this.formDefinitionKey + "' for tenant identifier " + this.tenantId, FormEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId != null) {
            formEntity = deploymentManager.findDeployedLatestFormByKeyAndParentDeploymentId(this.formDefinitionKey, this.parentDeploymentId);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for key '" + this.formDefinitionKey + "' for parent deployment id " + this.parentDeploymentId, FormEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId != null) {
            formEntity = deploymentManager.findDeployedLatestFormByKeyParentDeploymentIdAndTenantId(this.formDefinitionKey, this.parentDeploymentId, this.tenantId);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for key '" + this.formDefinitionKey + "for parent deployment id '" + this.parentDeploymentId + "' and for tenant identifier " + this.tenantId, FormEntity.class);
            }
        } else {
            throw new ActivitiFormObjectNotFoundException("formDefinitionKey and formDefinitionId are null");
        }
        FormCacheEntry formCacheEntry = deploymentManager.resolveForm(formEntity);
        FormJsonConverter formJsonConverter = commandContext.getFormEngineConfiguration().getFormJsonConverter();
        return formJsonConverter.convertToForm(formCacheEntry.getFormJson(), formEntity.getId(), formEntity.getVersion());
    }
}

