/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.cmd;

import org.activiti.form.engine.ActivitiFormIllegalArgumentException;
import org.activiti.form.engine.ActivitiFormObjectNotFoundException;
import org.activiti.form.engine.impl.interceptor.Command;
import org.activiti.form.engine.impl.interceptor.CommandContext;
import org.activiti.form.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.form.engine.impl.persistence.deploy.FormCacheEntry;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;

public class SetFormCategoryCmd
implements Command<Void> {
    protected String formId;
    protected String category;

    public SetFormCategoryCmd(String formId, String category) {
        this.formId = formId;
        this.category = category;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.formId == null) {
            throw new ActivitiFormIllegalArgumentException("Form id is null");
        }
        FormEntity form = (FormEntity)commandContext.getFormEntityManager().findById(this.formId);
        if (form == null) {
            throw new ActivitiFormObjectNotFoundException("No form found for id = '" + this.formId + "'");
        }
        form.setCategory(this.category);
        DeploymentCache<FormCacheEntry> formCache = commandContext.getFormEngineConfiguration().getFormCache();
        if (formCache != null) {
            formCache.remove(this.formId);
        }
        commandContext.getFormEntityManager().update(form);
        return null;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

