/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.cmd;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.activiti.form.api.SubmittedForm;
import org.activiti.form.engine.ActivitiFormException;
import org.activiti.form.engine.impl.interceptor.Command;
import org.activiti.form.engine.impl.interceptor.CommandContext;
import org.activiti.form.engine.impl.persistence.entity.SubmittedFormEntity;
import org.activiti.form.engine.impl.persistence.entity.SubmittedFormEntityManager;
import org.activiti.form.model.FormDefinition;
import org.activiti.form.model.FormField;
import org.joda.time.LocalDate;

public class StoreSubmittedFormCmd
implements Command<SubmittedForm>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected FormDefinition formDefinition;
    protected Map<String, Object> variables;
    protected String taskId;
    protected String processInstanceId;

    public StoreSubmittedFormCmd(FormDefinition formDefinition, Map<String, Object> variables, String taskId, String processInstanceId) {
        this.formDefinition = formDefinition;
        this.variables = variables;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public SubmittedForm execute(CommandContext commandContext) {
        if (this.formDefinition == null || this.formDefinition.getId() == null) {
            throw new ActivitiFormException("Invalid form definition provided");
        }
        ObjectMapper objectMapper = commandContext.getFormEngineConfiguration().getObjectMapper();
        ObjectNode submittedFormValuesJson = objectMapper.createObjectNode();
        ObjectNode valuesNode = submittedFormValuesJson.putObject("values");
        Map fieldMap = this.formDefinition.allFieldsAsMap();
        for (String fieldId : fieldMap.keySet()) {
            FormField formField = (FormField)fieldMap.get(fieldId);
            if ("expression".equals(formField.getType()) || "container".equals(formField.getType()) || !this.variables.containsKey(fieldId)) continue;
            Object variableValue = this.variables.get(fieldId);
            if (variableValue == null) {
                valuesNode.putNull(fieldId);
                continue;
            }
            if (variableValue instanceof Long) {
                valuesNode.put(fieldId, (Long)this.variables.get(fieldId));
                continue;
            }
            if (variableValue instanceof Double) {
                valuesNode.put(fieldId, (Double)this.variables.get(fieldId));
                continue;
            }
            if (variableValue instanceof LocalDate) {
                valuesNode.put(fieldId, ((LocalDate)variableValue).toString());
                continue;
            }
            valuesNode.put(fieldId, variableValue.toString());
        }
        String outcomeVariable = null;
        outcomeVariable = this.formDefinition.getOutcomeVariableName() != null ? this.formDefinition.getOutcomeVariableName() : "form_" + this.formDefinition.getKey() + "_outcome";
        if (this.variables.containsKey(outcomeVariable) && this.variables.get(outcomeVariable) != null) {
            submittedFormValuesJson.put("activiti_form_outcome", this.variables.get(outcomeVariable).toString());
        }
        SubmittedFormEntityManager submittedFormEntityManager = commandContext.getSubmittedFormEntityManager();
        SubmittedFormEntity submittedFormEntity = (SubmittedFormEntity)submittedFormEntityManager.create();
        submittedFormEntity.setFormId(this.formDefinition.getId());
        submittedFormEntity.setTaskId(this.taskId);
        submittedFormEntity.setProcessInstanceId(this.processInstanceId);
        submittedFormEntity.setSubmittedDate(new Date());
        try {
            submittedFormEntity.setFormValueBytes(objectMapper.writeValueAsBytes((Object)submittedFormValuesJson));
        }
        catch (Exception e) {
            throw new ActivitiFormException("Error setting form values JSON", e);
        }
        submittedFormEntityManager.insert(submittedFormEntity);
        return submittedFormEntity;
    }
}

