/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.context;

import java.util.Stack;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.impl.interceptor.CommandContext;

public class Context {
    protected static ThreadLocal<Stack<CommandContext>> commandContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<FormEngineConfiguration>> formEngineConfigurationStackThreadLocal = new ThreadLocal();

    public static CommandContext getCommandContext() {
        Stack stack = Context.getStack(commandContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CommandContext)stack.peek();
    }

    public static void setCommandContext(CommandContext commandContext) {
        Context.getStack(commandContextThreadLocal).push(commandContext);
    }

    public static void removeCommandContext() {
        Context.getStack(commandContextThreadLocal).pop();
    }

    public static FormEngineConfiguration getFormEngineConfiguration() {
        Stack stack = Context.getStack(formEngineConfigurationStackThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (FormEngineConfiguration)stack.peek();
    }

    public static void setFormEngineConfiguration(FormEngineConfiguration formEngineConfiguration) {
        Context.getStack(formEngineConfigurationStackThreadLocal).push(formEngineConfiguration);
    }

    public static void removeFormEngineConfiguration() {
        Context.getStack(formEngineConfigurationStackThreadLocal).pop();
    }

    protected static <T> Stack<T> getStack(ThreadLocal<Stack<T>> threadLocal) {
        Stack<Object> stack = threadLocal.get();
        if (stack == null) {
            stack = new Stack();
            threadLocal.set(stack);
        }
        return stack;
    }
}

