/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.db;

import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.activiti.form.engine.FormEngine;
import org.activiti.form.engine.FormEngines;
import org.apache.commons.lang3.StringUtils;

public class DbSchemaDrop {
    public static void main(String[] args) {
        try {
            FormEngine formEngine = FormEngines.getDefaultFormEngine();
            DataSource dataSource = formEngine.getFormEngineConfiguration().getDataSource();
            JdbcConnection connection = new JdbcConnection(dataSource.getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName("ACT_FO_" + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName("ACT_FO_" + database.getDatabaseChangeLogLockTableName());
            if (StringUtils.isNotEmpty((CharSequence)formEngine.getFormEngineConfiguration().getDatabaseSchema())) {
                database.setDefaultSchemaName(formEngine.getFormEngineConfiguration().getDatabaseSchema());
                database.setLiquibaseSchemaName(formEngine.getFormEngineConfiguration().getDatabaseSchema());
            }
            if (StringUtils.isNotEmpty((CharSequence)formEngine.getFormEngineConfiguration().getDatabaseCatalog())) {
                database.setDefaultCatalogName(formEngine.getFormEngineConfiguration().getDatabaseCatalog());
                database.setLiquibaseCatalogName(formEngine.getFormEngineConfiguration().getDatabaseCatalog());
            }
            Liquibase liquibase = new Liquibase("org/activiti/form/db/liquibase/activiti-form-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.dropAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

