/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.db;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import org.activiti.form.engine.ActivitiFormException;
import org.activiti.form.engine.ActivitiFormOptimisticLockingException;
import org.activiti.form.engine.impl.Page;
import org.activiti.form.engine.impl.db.DbSqlSessionFactory;
import org.activiti.form.engine.impl.db.Entity;
import org.activiti.form.engine.impl.db.ListQueryParameterObject;
import org.activiti.form.engine.impl.interceptor.Session;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSqlSession
implements Session {
    private static final Logger log = LoggerFactory.getLogger(DbSqlSession.class);
    protected SqlSession sqlSession;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected String connectionMetadataDefaultCatalog;
    protected String connectionMetadataDefaultSchema;

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession();
    }

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, Connection connection, String catalog, String schema) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession(connection);
        this.connectionMetadataDefaultCatalog = catalog;
        this.connectionMetadataDefaultSchema = schema;
    }

    public void insert(Entity entity) {
        if (entity.getId() == null) {
            String id = this.dbSqlSessionFactory.getIdGenerator().getNextId();
            entity.setId(id);
        }
        String insertStatement = this.dbSqlSessionFactory.getInsertStatement(entity);
        if ((insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement)) == null) {
            throw new ActivitiFormException("no insert statement for " + entity.getClass() + " in the ibatis mapping files");
        }
        log.debug("inserting: {}", (Object)entity);
        this.sqlSession.insert(insertStatement, (Object)entity);
    }

    public void update(Entity entity) {
        String updateStatement = this.dbSqlSessionFactory.getUpdateStatement(entity);
        if ((updateStatement = this.dbSqlSessionFactory.mapStatement(updateStatement)) == null) {
            throw new ActivitiFormException("no update statement for " + entity.getClass() + " in the ibatis mapping files");
        }
        log.debug("updating: {}", (Object)entity);
        int updatedRecords = this.sqlSession.update(updateStatement, (Object)entity);
        if (updatedRecords == 0) {
            throw new ActivitiFormOptimisticLockingException(entity + " was updated by another transaction concurrently");
        }
    }

    public int update(String statement, Object parameters) {
        String updateStatement = this.dbSqlSessionFactory.mapStatement(statement);
        return this.sqlSession.update(updateStatement, parameters);
    }

    public void delete(String statement, Object parameter) {
        this.sqlSession.delete(statement, parameter);
    }

    public void delete(Entity entity) {
        String deleteStatement = this.dbSqlSessionFactory.getDeleteStatement(entity.getClass());
        if ((deleteStatement = this.dbSqlSessionFactory.mapStatement(deleteStatement)) == null) {
            throw new ActivitiFormException("no delete statement for " + entity.getClass() + " in the ibatis mapping files");
        }
        this.sqlSession.delete(deleteStatement, (Object)entity);
    }

    public List selectList(String statement) {
        return this.selectList(statement, null, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter) {
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter, Page page) {
        if (page != null) {
            return this.selectList(statement, parameter, page.getFirstResult(), page.getMaxResults());
        }
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, ListQueryParameterObject parameter, Page page) {
        if (page != null) {
            parameter.setFirstResult(page.getFirstResult());
            parameter.setMaxResults(page.getMaxResults());
        }
        return this.selectList(statement, parameter);
    }

    public List selectList(String statement, Object parameter, int firstResult, int maxResults) {
        return this.selectList(statement, new ListQueryParameterObject(parameter, firstResult, maxResults));
    }

    public List selectList(String statement, ListQueryParameterObject parameter) {
        return this.selectListWithRawParameter(statement, parameter, parameter.getFirstResult(), parameter.getMaxResults());
    }

    public List selectListWithRawParameter(String statement, Object parameter, int firstResult, int maxResults) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        if (firstResult == -1 || maxResults == -1) {
            return Collections.EMPTY_LIST;
        }
        List loadedObjects = this.sqlSession.selectList(statement, parameter);
        return loadedObjects;
    }

    public List selectListWithRawParameterWithoutFilter(String statement, Object parameter, int firstResult, int maxResults) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        if (firstResult == -1 || maxResults == -1) {
            return Collections.EMPTY_LIST;
        }
        return this.sqlSession.selectList(statement, parameter);
    }

    public Object selectOne(String statement, Object parameter) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        Object result = this.sqlSession.selectOne(statement, parameter);
        return result;
    }

    public <T extends Entity> T selectById(Class<T> entityClass, String id) {
        Entity entity = null;
        String selectStatement = this.dbSqlSessionFactory.getSelectStatement(entityClass);
        entity = (Entity)this.sqlSession.selectOne(selectStatement = this.dbSqlSessionFactory.mapStatement(selectStatement), (Object)id);
        if (entity == null) {
            return null;
        }
        return (T)entity;
    }

    @Override
    public void flush() {
        this.sqlSession.flushStatements();
    }

    @Override
    public void close() {
        this.sqlSession.close();
    }

    public void commit() {
        this.sqlSession.commit();
    }

    public void rollback() {
        this.sqlSession.rollback();
    }

    public void dbSchemaCheckVersion() {
        log.debug("activiti db schema check successful");
    }

    public void dbSchemaCreate() {
    }

    public void dbSchemaDrop() {
    }

    public <T> T getCustomMapper(Class<T> type) {
        return (T)this.sqlSession.getMapper(type);
    }

    public boolean isMysql() {
        return this.dbSqlSessionFactory.getDatabaseType().equals("mysql");
    }

    public boolean isOracle() {
        return this.dbSqlSessionFactory.getDatabaseType().equals("oracle");
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }
}

