/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.deployer;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.activiti.form.engine.impl.context.Context;
import org.activiti.form.engine.impl.deployer.ParsedDeployment;
import org.activiti.form.engine.impl.parser.FormParse;
import org.activiti.form.engine.impl.parser.FormParseFactory;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;
import org.activiti.form.engine.impl.persistence.entity.ResourceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedDeploymentBuilder {
    private static final Logger log = LoggerFactory.getLogger(ParsedDeploymentBuilder.class);
    public static final String[] FORM_RESOURCE_SUFFIXES = new String[]{"form"};
    protected FormDeploymentEntity deployment;
    protected FormParseFactory formParseFactory;

    public ParsedDeploymentBuilder(FormDeploymentEntity deployment, FormParseFactory formParseFactory) {
        this.deployment = deployment;
        this.formParseFactory = formParseFactory;
    }

    public ParsedDeployment build() {
        ArrayList<FormEntity> forms = new ArrayList<FormEntity>();
        LinkedHashMap<FormEntity, FormParse> formToParseMap = new LinkedHashMap<FormEntity, FormParse>();
        LinkedHashMap<FormEntity, ResourceEntity> formToResourceMap = new LinkedHashMap<FormEntity, ResourceEntity>();
        for (ResourceEntity resource : this.deployment.getResources().values()) {
            if (!this.isFormResource(resource.getName())) continue;
            log.debug("Processing Form resource {}", (Object)resource.getName());
            FormParse parse = this.createFormParseFromResource(resource);
            for (FormEntity form : parse.getForms()) {
                forms.add(form);
                formToParseMap.put(form, parse);
                formToResourceMap.put(form, resource);
            }
        }
        return new ParsedDeployment(this.deployment, forms, formToParseMap, formToResourceMap);
    }

    protected FormParse createFormParseFromResource(ResourceEntity resource) {
        String resourceName = resource.getName();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.getBytes());
        FormParse formParse = this.formParseFactory.createParse().sourceInputStream(inputStream).setSourceSystemId(resourceName).deployment(this.deployment).name(resourceName);
        formParse.execute(Context.getFormEngineConfiguration());
        return formParse;
    }

    protected boolean isFormResource(String resourceName) {
        for (String suffix : FORM_RESOURCE_SUFFIXES) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

