/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.el;

import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import org.activiti.form.engine.ActivitiFormException;
import org.activiti.form.engine.FormExpression;
import org.activiti.form.engine.impl.el.ActivitiFormElContext;
import org.activiti.form.engine.impl.el.ExpressionManager;

public class JuelExpression
implements FormExpression {
    private static final long serialVersionUID = 1L;
    protected String expressionText;
    protected ValueExpression valueExpression;
    protected ExpressionManager expressionManager;

    public JuelExpression(ValueExpression valueExpression, String expressionText, ExpressionManager expressionManager) {
        this.valueExpression = valueExpression;
        this.expressionText = expressionText;
        this.expressionManager = expressionManager;
    }

    @Override
    public Object getValue(Map<String, Object> variables) {
        ActivitiFormElContext elContext = this.expressionManager.createElContext(variables);
        try {
            return this.valueExpression.getValue((ELContext)elContext);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ActivitiFormException("Unknown property used in expression: " + this.expressionText, pnfe);
        }
        catch (MethodNotFoundException mnfe) {
            throw new ActivitiFormException("Unknown method used in expression: " + this.expressionText, mnfe);
        }
        catch (ELException ele) {
            throw new ActivitiFormException("Error while evaluating expression: " + this.expressionText, ele);
        }
        catch (Exception e) {
            throw new ActivitiFormException("Error while evaluating expression: " + this.expressionText, e);
        }
    }

    @Override
    public void setValue(Object value, Map<String, Object> variables) {
    }

    public String toString() {
        if (this.valueExpression != null) {
            return this.valueExpression.getExpressionString();
        }
        return super.toString();
    }

    @Override
    public String getExpressionText() {
        return this.expressionText;
    }
}

