/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.form.engine.ActivitiFormException;
import org.activiti.form.engine.ActivitiFormOptimisticLockingException;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.impl.cfg.TransactionContext;
import org.activiti.form.engine.impl.db.DbSqlSession;
import org.activiti.form.engine.impl.interceptor.Command;
import org.activiti.form.engine.impl.interceptor.CommandContextCloseListener;
import org.activiti.form.engine.impl.interceptor.Session;
import org.activiti.form.engine.impl.interceptor.SessionFactory;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntityManager;
import org.activiti.form.engine.impl.persistence.entity.FormEntityManager;
import org.activiti.form.engine.impl.persistence.entity.ResourceEntityManager;
import org.activiti.form.engine.impl.persistence.entity.SubmittedFormEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandContext {
    private static Logger log = LoggerFactory.getLogger(CommandContext.class);
    protected Command<?> command;
    protected TransactionContext transactionContext;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected Map<Class<?>, Session> sessions = new HashMap();
    protected Throwable exception;
    protected FormEngineConfiguration formEngineConfiguration;
    protected List<CommandContextCloseListener> closeListeners;
    protected Map<String, Object> attributes;

    public CommandContext(Command<?> command, FormEngineConfiguration formEngineConfiguration) {
        this.command = command;
        this.formEngineConfiguration = formEngineConfiguration;
        this.sessionFactories = formEngineConfiguration.getSessionFactories();
        this.transactionContext = formEngineConfiguration.getTransactionContextFactory().openTransactionContext(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        block42: {
            try {
                try {
                    try {
                        if (this.closeListeners != null) {
                            try {
                                for (CommandContextCloseListener listener : this.closeListeners) {
                                    listener.closing(this);
                                }
                            }
                            catch (Throwable exception) {
                                this.exception(exception);
                            }
                        }
                        if (this.exception == null) {
                            this.flushSessions();
                        }
                    }
                    catch (Throwable exception) {
                        try {
                            this.exception(exception);
                            break block42;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (this.exception == null) {
                                    this.transactionContext.commit();
                                }
                            }
                            catch (Throwable exception2) {
                                this.exception(exception2);
                            }
                            if (this.closeListeners != null) {
                                try {
                                    for (CommandContextCloseListener listener : this.closeListeners) {
                                        listener.closed(this);
                                    }
                                }
                                catch (Throwable exception3) {
                                    this.exception(exception3);
                                }
                            }
                            if (this.exception != null) {
                                if (this.exception instanceof ActivitiFormOptimisticLockingException) {
                                    log.debug("Optimistic locking exception : " + this.exception);
                                } else {
                                    log.debug("Error while closing command context", this.exception);
                                }
                                this.transactionContext.rollback();
                            }
                        }
                    }
                    try {
                        if (this.exception == null) {
                            this.transactionContext.commit();
                        }
                    }
                    catch (Throwable exception) {
                        this.exception(exception);
                    }
                    if (this.closeListeners != null) {
                        try {
                            for (CommandContextCloseListener listener : this.closeListeners) {
                                listener.closed(this);
                            }
                        }
                        catch (Throwable exception) {
                            this.exception(exception);
                        }
                    }
                    if (this.exception != null) {
                        if (this.exception instanceof ActivitiFormOptimisticLockingException) {
                            log.debug("Optimistic locking exception : " + this.exception);
                        } else {
                            log.debug("Error while closing command context", this.exception);
                        }
                        this.transactionContext.rollback();
                    }
                }
                catch (Throwable exception) {
                    this.exception(exception);
                }
                finally {
                    this.closeSessions();
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
        if (this.exception == null) return;
        if (this.exception instanceof Error) {
            throw (Error)this.exception;
        }
        if (!(this.exception instanceof RuntimeException)) throw new ActivitiFormException("exception while executing command " + this.command, this.exception);
        throw (RuntimeException)this.exception;
    }

    public void addCloseListener(CommandContextCloseListener commandContextCloseListener) {
        if (this.closeListeners == null) {
            this.closeListeners = new ArrayList<CommandContextCloseListener>(1);
        }
        this.closeListeners.add(commandContextCloseListener);
    }

    public List<CommandContextCloseListener> getCloseListeners() {
        return this.closeListeners;
    }

    protected void flushSessions() {
        for (Session session : this.sessions.values()) {
            session.flush();
        }
    }

    protected void closeSessions() {
        for (Session session : this.sessions.values()) {
            try {
                session.close();
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    public void exception(Throwable exception) {
        if (this.exception == null) {
            this.exception = exception;
        } else {
            log.error("masked exception in command context. for root cause, see below as it will be rethrown later.", exception);
        }
    }

    public void addAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(1);
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public <T> T getSession(Class<T> sessionClass) {
        Session session = this.sessions.get(sessionClass);
        if (session == null) {
            SessionFactory sessionFactory = this.sessionFactories.get(sessionClass);
            if (sessionFactory == null) {
                throw new ActivitiFormException("no session factory configured for " + sessionClass.getName());
            }
            session = sessionFactory.openSession(this);
            this.sessions.put(sessionClass, session);
        }
        return (T)session;
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    public FormDeploymentEntityManager getDeploymentEntityManager() {
        return this.formEngineConfiguration.getDeploymentEntityManager();
    }

    public FormEntityManager getFormEntityManager() {
        return this.formEngineConfiguration.getFormEntityManager();
    }

    public ResourceEntityManager getResourceEntityManager() {
        return this.formEngineConfiguration.getResourceEntityManager();
    }

    public SubmittedFormEntityManager getSubmittedFormEntityManager() {
        return this.formEngineConfiguration.getSubmittedFormEntityManager();
    }

    public FormEngineConfiguration getFormEngineConfiguration() {
        return this.formEngineConfiguration;
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public Command<?> getCommand() {
        return this.command;
    }

    public Map<Class<?>, Session> getSessions() {
        return this.sessions;
    }

    public Throwable getException() {
        return this.exception;
    }
}

