/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.persistence.deploy;

import java.util.List;
import org.activiti.form.api.Form;
import org.activiti.form.engine.ActivitiFormException;
import org.activiti.form.engine.ActivitiFormObjectNotFoundException;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.impl.FormQueryImpl;
import org.activiti.form.engine.impl.persistence.deploy.Deployer;
import org.activiti.form.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.form.engine.impl.persistence.deploy.FormCacheEntry;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntityManager;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;
import org.activiti.form.engine.impl.persistence.entity.FormEntityManager;
import org.activiti.form.engine.impl.persistence.entity.ResourceEntity;

public class DeploymentManager {
    protected FormEngineConfiguration engineConfig;
    protected DeploymentCache<FormCacheEntry> formCache;
    protected List<Deployer> deployers;
    protected FormEntityManager formEntityManager;
    protected FormDeploymentEntityManager deploymentEntityManager;

    public DeploymentManager(DeploymentCache<FormCacheEntry> formCache, FormEngineConfiguration engineConfig) {
        this.formCache = formCache;
        this.engineConfig = engineConfig;
    }

    public void deploy(FormDeploymentEntity deployment) {
        for (Deployer deployer : this.deployers) {
            deployer.deploy(deployment);
        }
    }

    public FormEntity findDeployedFormById(String formId) {
        FormEntity form;
        if (formId == null) {
            throw new ActivitiFormException("Invalid form id : null");
        }
        FormCacheEntry cacheEntry = this.formCache.get(formId);
        FormEntity formEntity = form = cacheEntry != null ? cacheEntry.getFormEntity() : null;
        if (form == null) {
            form = (FormEntity)this.engineConfig.getFormEntityManager().findById(formId);
            if (form == null) {
                throw new ActivitiFormObjectNotFoundException("no deployed form found with id '" + formId + "'");
            }
            form = this.resolveForm(form).getFormEntity();
        }
        return form;
    }

    public FormEntity findDeployedLatestFormByKey(String formDefinitionKey) {
        FormEntity form = this.formEntityManager.findLatestFormByKey(formDefinitionKey);
        if (form == null) {
            throw new ActivitiFormObjectNotFoundException("no forms deployed with key '" + formDefinitionKey + "'");
        }
        form = this.resolveForm(form).getFormEntity();
        return form;
    }

    public FormEntity findDeployedLatestFormByKeyAndTenantId(String formDefinitionKey, String tenantId) {
        FormEntity form = this.formEntityManager.findLatestFormByKeyAndTenantId(formDefinitionKey, tenantId);
        if (form == null) {
            throw new ActivitiFormObjectNotFoundException("no forms deployed with key '" + formDefinitionKey + "' for tenant identifier '" + tenantId + "'");
        }
        form = this.resolveForm(form).getFormEntity();
        return form;
    }

    public FormEntity findDeployedLatestFormByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId) {
        FormEntity form = this.formEntityManager.findLatestFormByKeyAndParentDeploymentId(formDefinitionKey, parentDeploymentId);
        if (form == null) {
            throw new ActivitiFormObjectNotFoundException("no forms deployed with key '" + formDefinitionKey + "' for parent deployment id '" + parentDeploymentId + "'");
        }
        form = this.resolveForm(form).getFormEntity();
        return form;
    }

    public FormEntity findDeployedLatestFormByKeyParentDeploymentIdAndTenantId(String formDefinitionKey, String parentDeploymentId, String tenantId) {
        FormEntity form = this.formEntityManager.findLatestFormByKeyParentDeploymentIdAndTenantId(formDefinitionKey, parentDeploymentId, tenantId);
        if (form == null) {
            throw new ActivitiFormObjectNotFoundException("no forms deployed with key '" + formDefinitionKey + "' for parent deployment id '" + parentDeploymentId + "' and tenant identifier '" + tenantId + "'");
        }
        form = this.resolveForm(form).getFormEntity();
        return form;
    }

    public FormEntity findDeployedFormByKeyAndVersionAndTenantId(String formDefinitionKey, int formVersion, String tenantId) {
        FormEntity form = this.formEntityManager.findFormByKeyAndVersionAndTenantId(formDefinitionKey, formVersion, tenantId);
        if (form == null) {
            throw new ActivitiFormObjectNotFoundException("no decisions deployed with key = '" + formDefinitionKey + "' and version = '" + formVersion + "'");
        }
        form = this.resolveForm(form).getFormEntity();
        return form;
    }

    public FormCacheEntry resolveForm(Form form) {
        String formId = form.getId();
        String deploymentId = form.getDeploymentId();
        FormCacheEntry cachedForm = this.formCache.get(formId);
        if (cachedForm == null) {
            FormDeploymentEntity deployment = (FormDeploymentEntity)this.engineConfig.getDeploymentEntityManager().findById(deploymentId);
            List<ResourceEntity> resources = this.engineConfig.getResourceEntityManager().findResourcesByDeploymentId(deploymentId);
            for (ResourceEntity resource : resources) {
                deployment.addResource(resource);
            }
            deployment.setNew(false);
            this.deploy(deployment);
            cachedForm = this.formCache.get(formId);
            if (cachedForm == null) {
                throw new ActivitiFormException("deployment '" + deploymentId + "' didn't put form '" + formId + "' in the cache");
            }
        }
        return cachedForm;
    }

    public void removeDeployment(String deploymentId) {
        FormDeploymentEntity deployment = (FormDeploymentEntity)this.deploymentEntityManager.findById(deploymentId);
        if (deployment == null) {
            throw new ActivitiFormObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.");
        }
        List forms = new FormQueryImpl().deploymentId(deploymentId).list();
        this.deploymentEntityManager.deleteDeployment(deploymentId);
        for (Form form : forms) {
            this.formCache.remove(form.getId());
        }
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    public DeploymentCache<FormCacheEntry> getFormCache() {
        return this.formCache;
    }

    public void setFormCache(DeploymentCache<FormCacheEntry> formCache) {
        this.formCache = formCache;
    }

    public FormEntityManager getFormEntityManager() {
        return this.formEntityManager;
    }

    public void setFormEntityManager(FormEntityManager formEntityManager) {
        this.formEntityManager = formEntityManager;
    }

    public FormDeploymentEntityManager getDeploymentEntityManager() {
        return this.deploymentEntityManager;
    }

    public void setDeploymentEntityManager(FormDeploymentEntityManager deploymentEntityManager) {
        this.deploymentEntityManager = deploymentEntityManager;
    }
}

