/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti.form.api.Form;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.impl.FormQueryImpl;
import org.activiti.form.engine.impl.Page;
import org.activiti.form.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;
import org.activiti.form.engine.impl.persistence.entity.FormEntityManager;
import org.activiti.form.engine.impl.persistence.entity.data.DataManager;
import org.activiti.form.engine.impl.persistence.entity.data.FormDataManager;

public class FormEntityManagerImpl
extends AbstractEntityManager<FormEntity>
implements FormEntityManager {
    protected FormDataManager formDataManager;

    public FormEntityManagerImpl(FormEngineConfiguration formEngineConfiguration, FormDataManager formDataManager) {
        super(formEngineConfiguration);
        this.formDataManager = formDataManager;
    }

    @Override
    protected DataManager<FormEntity> getDataManager() {
        return this.formDataManager;
    }

    @Override
    public FormEntity findLatestFormByKey(String formDefinitionKey) {
        return this.formDataManager.findLatestFormByKey(formDefinitionKey);
    }

    @Override
    public FormEntity findLatestFormByKeyAndTenantId(String formDefinitionKey, String tenantId) {
        return this.formDataManager.findLatestFormByKeyAndTenantId(formDefinitionKey, tenantId);
    }

    @Override
    public FormEntity findLatestFormByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId) {
        return this.formDataManager.findLatestFormByKeyAndParentDeploymentId(formDefinitionKey, parentDeploymentId);
    }

    @Override
    public FormEntity findLatestFormByKeyParentDeploymentIdAndTenantId(String formDefinitionKey, String parentDeploymentId, String tenantId) {
        return this.formDataManager.findLatestFormByKeyParentDeploymentIdAndTenantId(formDefinitionKey, parentDeploymentId, tenantId);
    }

    @Override
    public void deleteFormsByDeploymentId(String deploymentId) {
        this.formDataManager.deleteFormsByDeploymentId(deploymentId);
    }

    @Override
    public List<Form> findFormsByQueryCriteria(FormQueryImpl formQuery, Page page) {
        return this.formDataManager.findFormsByQueryCriteria(formQuery, page);
    }

    @Override
    public long findFormCountByQueryCriteria(FormQueryImpl formQuery) {
        return this.formDataManager.findFormCountByQueryCriteria(formQuery);
    }

    @Override
    public FormEntity findFormByDeploymentAndKey(String deploymentId, String formDefinitionKey) {
        return this.formDataManager.findFormByDeploymentAndKey(deploymentId, formDefinitionKey);
    }

    @Override
    public FormEntity findFormByDeploymentAndKeyAndTenantId(String deploymentId, String formDefinitionKey, String tenantId) {
        return this.formDataManager.findFormByDeploymentAndKeyAndTenantId(deploymentId, formDefinitionKey, tenantId);
    }

    @Override
    public FormEntity findFormByKeyAndVersionAndTenantId(String formDefinitionKey, Integer formVersion, String tenantId) {
        if (tenantId == null || "".equals(tenantId)) {
            return this.formDataManager.findFormByKeyAndVersion(formDefinitionKey, formVersion);
        }
        return this.formDataManager.findFormByKeyAndVersionAndTenantId(formDefinitionKey, formVersion, tenantId);
    }

    @Override
    public List<Form> findFormsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.formDataManager.findFormsByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public long findFormCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.formDataManager.findFormCountByNativeQuery(parameterMap);
    }

    @Override
    public void updateFormTenantIdForDeployment(String deploymentId, String newTenantId) {
        this.formDataManager.updateFormTenantIdForDeployment(deploymentId, newTenantId);
    }

    public FormDataManager getFormDataManager() {
        return this.formDataManager;
    }

    public void setFormDataManager(FormDataManager formDataManager) {
        this.formDataManager = formDataManager;
    }
}

