/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.persistence.entity.data.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.form.api.Form;
import org.activiti.form.engine.ActivitiFormException;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.impl.FormQueryImpl;
import org.activiti.form.engine.impl.Page;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;
import org.activiti.form.engine.impl.persistence.entity.FormEntityImpl;
import org.activiti.form.engine.impl.persistence.entity.data.AbstractDataManager;
import org.activiti.form.engine.impl.persistence.entity.data.FormDataManager;

public class MybatisFormDataManager
extends AbstractDataManager<FormEntity>
implements FormDataManager {
    public MybatisFormDataManager(FormEngineConfiguration formEngineConfiguration) {
        super(formEngineConfiguration);
    }

    @Override
    public Class<? extends FormEntity> getManagedEntityClass() {
        return FormEntityImpl.class;
    }

    @Override
    public FormEntity create() {
        return new FormEntityImpl();
    }

    @Override
    public FormEntity findLatestFormByKey(String formDefinitionKey) {
        return (FormEntity)this.getDbSqlSession().selectOne("selectLatestFormByKey", formDefinitionKey);
    }

    @Override
    public FormEntity findLatestFormByKeyAndTenantId(String formDefinitionKey, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("formDefinitionKey", formDefinitionKey);
        params.put("tenantId", tenantId);
        return (FormEntity)this.getDbSqlSession().selectOne("selectLatestFormByKeyAndTenantId", params);
    }

    @Override
    public FormEntity findLatestFormByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("formDefinitionKey", formDefinitionKey);
        params.put("parentDeploymentId", parentDeploymentId);
        return (FormEntity)this.getDbSqlSession().selectOne("selectLatestFormByKeyAndParentDeploymentId", params);
    }

    @Override
    public FormEntity findLatestFormByKeyParentDeploymentIdAndTenantId(String formDefinitionKey, String parentDeploymentId, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("formDefinitionKey", formDefinitionKey);
        params.put("parentDeploymentId", parentDeploymentId);
        params.put("tenantId", tenantId);
        return (FormEntity)this.getDbSqlSession().selectOne("selectLatestFormByKeyParentDeploymentIdAndTenantId", params);
    }

    @Override
    public void deleteFormsByDeploymentId(String deploymentId) {
        this.getDbSqlSession().delete("deleteFormsByDeploymentId", deploymentId);
    }

    @Override
    public List<Form> findFormsByQueryCriteria(FormQueryImpl formQuery, Page page) {
        return this.getDbSqlSession().selectList("selectFormsByQueryCriteria", formQuery, page);
    }

    @Override
    public long findFormCountByQueryCriteria(FormQueryImpl formQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectFormCountByQueryCriteria", formQuery);
    }

    @Override
    public FormEntity findFormByDeploymentAndKey(String deploymentId, String formDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("formDefinitionKey", formDefinitionKey);
        return (FormEntity)this.getDbSqlSession().selectOne("selectFormByDeploymentAndKey", parameters);
    }

    @Override
    public FormEntity findFormByDeploymentAndKeyAndTenantId(String deploymentId, String formDefinitionKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("formDefinitionKey", formDefinitionKey);
        parameters.put("tenantId", tenantId);
        return (FormEntity)this.getDbSqlSession().selectOne("selectFormByDeploymentAndKeyAndTenantId", parameters);
    }

    @Override
    public FormEntity findFormByKeyAndVersion(String formDefinitionKey, Integer formVersion) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formDefinitionKey", formDefinitionKey);
        params.put("formVersion", formVersion);
        List results = this.getDbSqlSession().selectList("selectFormsByKeyAndVersion", params);
        if (results.size() == 1) {
            return (FormEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new ActivitiFormException("There are " + results.size() + " forms with key = '" + formDefinitionKey + "' and version = '" + formVersion + "'.");
        }
        return null;
    }

    @Override
    public FormEntity findFormByKeyAndVersionAndTenantId(String formDefinitionKey, Integer formVersion, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formDefinitionKey", formDefinitionKey);
        params.put("formVersion", formVersion);
        params.put("tenantId", tenantId);
        List results = this.getDbSqlSession().selectList("selectFormsByKeyAndVersionAndTenantId", params);
        if (results.size() == 1) {
            return (FormEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new ActivitiFormException("There are " + results.size() + " forms with key = '" + formDefinitionKey + "' and version = '" + formVersion + "'.");
        }
        return null;
    }

    @Override
    public List<Form> findFormsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectFormByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public long findFormCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectFormCountByNativeQuery", parameterMap);
    }

    @Override
    public void updateFormTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateFormTenantIdForDeploymentId", params);
    }
}

