/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.util;

import org.activiti.form.engine.ActivitiFormException;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.impl.context.Context;
import org.activiti.form.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.form.engine.impl.persistence.deploy.FormCacheEntry;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;
import org.activiti.form.engine.impl.persistence.entity.FormEntityManager;
import org.activiti.form.model.FormDefinition;

public class FormUtil {
    public static FormEntity getFormEntity(String formId) {
        return FormUtil.getFormEntity(formId, false);
    }

    public static FormEntity getFormEntity(String formId, boolean checkCacheOnly) {
        if (checkCacheOnly) {
            FormCacheEntry cacheEntry = Context.getFormEngineConfiguration().getFormCache().get(formId);
            if (cacheEntry != null) {
                return cacheEntry.getFormEntity();
            }
            return null;
        }
        return Context.getFormEngineConfiguration().getDeploymentManager().findDeployedFormById(formId);
    }

    public static FormDefinition getFormDefinition(String formId) {
        FormEngineConfiguration formEngineConfiguration = Context.getFormEngineConfiguration();
        DeploymentManager deploymentManager = formEngineConfiguration.getDeploymentManager();
        FormEntity formEntity = deploymentManager.findDeployedFormById(formId);
        FormCacheEntry cacheEntry = deploymentManager.resolveForm(formEntity);
        return formEngineConfiguration.getFormJsonConverter().convertToForm(cacheEntry.getFormJson(), cacheEntry.getFormEntity().getId(), cacheEntry.getFormEntity().getVersion());
    }

    public static FormDefinition getFormDefinitionFromCache(String formId) {
        FormEngineConfiguration formEngineConfiguration = Context.getFormEngineConfiguration();
        FormCacheEntry cacheEntry = formEngineConfiguration.getFormCache().get(formId);
        if (cacheEntry != null) {
            return formEngineConfiguration.getFormJsonConverter().convertToForm(cacheEntry.getFormJson(), cacheEntry.getFormEntity().getId(), cacheEntry.getFormEntity().getVersion());
        }
        return null;
    }

    public static FormEntity getFormDefinitionFromDatabase(String formId) {
        FormEntityManager formEntityManager = Context.getFormEngineConfiguration().getFormEntityManager();
        FormEntity form = (FormEntity)formEntityManager.findById(formId);
        if (form == null) {
            throw new ActivitiFormException("No form found with id " + formId);
        }
        return form;
    }
}

