/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.form.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.activiti.editor.form.converter.ActivitiFormJsonException;
import org.activiti.form.model.FormDefinition;

public class FormJsonConverter {
    protected ObjectMapper objectMapper = new ObjectMapper();

    public FormDefinition convertToForm(String modelJson, String modelId, int modelVersion) {
        try {
            FormDefinition definition = (FormDefinition)this.objectMapper.readValue(modelJson, FormDefinition.class);
            definition.setId(modelId);
            definition.setVersion(modelVersion);
            return definition;
        }
        catch (Exception e) {
            throw new ActivitiFormJsonException("Error reading form json", e);
        }
    }

    public String convertToJson(FormDefinition definition) {
        try {
            return this.objectMapper.writeValueAsString((Object)definition);
        }
        catch (Exception e) {
            throw new ActivitiFormJsonException("Error writing form json", e);
        }
    }
}

