/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.TextAnnotation;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.apache.commons.lang3.StringUtils;

public class TextAnnotationJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        TextAnnotationJsonConverter.fillJsonTypes(convertersToBpmnMap);
        TextAnnotationJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("TextAnnotation", TextAnnotationJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(TextAnnotation.class, TextAnnotationJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "TextAnnotation";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        TextAnnotation annotation = (TextAnnotation)baseElement;
        if (StringUtils.isNotEmpty((CharSequence)annotation.getText())) {
            this.setPropertyValue("text", annotation.getText(), propertiesNode);
        }
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        TextAnnotation annotation = new TextAnnotation();
        String text = this.getPropertyValueAsString("text", elementNode);
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            annotation.setText(text);
        }
        return annotation;
    }
}

