/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.mule;

import java.util.Map;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.scripting.ScriptingEngines;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;

public class MuleSendActivitiBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    private MuleContext muleContext;
    private MessageExchangePattern mep = MessageExchangePattern.REQUEST_RESPONSE;
    private Expression endpointUrl;
    private Expression language;
    private Expression payloadExpression;
    private Expression resultVariable;

    public void execute(ActivityExecution execution) throws Exception {
        String endpointUrlValue = this.getStringFromField(this.endpointUrl, (DelegateExecution)execution);
        String languageValue = this.getStringFromField(this.language, (DelegateExecution)execution);
        String payloadExpressionValue = this.getStringFromField(this.payloadExpression, (DelegateExecution)execution);
        String resultVariableValue = this.getStringFromField(this.resultVariable, (DelegateExecution)execution);
        LocalMuleClient client = this.getMuleContext().getClient();
        ScriptingEngines scriptingEngines = Context.getProcessEngineConfiguration().getScriptingEngines();
        Object payload = scriptingEngines.evaluate(payloadExpressionValue, languageValue, (VariableScope)execution);
        DefaultMuleMessage message = new DefaultMuleMessage(payload, this.getMuleContext());
        switch (this.mep) {
            case REQUEST_RESPONSE: {
                MuleMessage resultMessage = client.send(endpointUrlValue, (MuleMessage)message);
                Object result = resultMessage.getPayload();
                if (resultVariableValue == null) break;
                execution.setVariable(resultVariableValue, result);
                break;
            }
            case ONE_WAY: {
                client.dispatch(endpointUrlValue, (MuleMessage)message);
                break;
            }
        }
        this.leave(execution);
    }

    private MuleContext getMuleContext() {
        if (this.muleContext == null) {
            Map beans = Context.getProcessEngineConfiguration().getBeans();
            this.muleContext = (MuleContext)beans.get("muleContext");
        }
        return this.muleContext;
    }

    protected String getStringFromField(Expression expression, DelegateExecution execution) {
        Object value;
        if (expression != null && (value = expression.getValue((VariableScope)execution)) != null) {
            return value.toString();
        }
        return null;
    }

    public MessageExchangePattern getMep() {
        return this.mep;
    }

    public void setMep(MessageExchangePattern mep) {
        this.mep = mep;
    }

    public Expression getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(Expression endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public Expression getPayloadExpression() {
        return this.payloadExpression;
    }

    public void setPayloadExpression(Expression payloadExpression) {
        this.payloadExpression = payloadExpression;
    }

    public Expression getResultVariable() {
        return this.resultVariable;
    }

    public void setResultVariable(Expression resultVariable) {
        this.resultVariable = resultVariable;
    }

    public Expression getLanguage() {
        return this.language;
    }

    public void setLanguage(Expression language) {
        this.language = language;
    }
}

