/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.osgi;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.activiti.osgi.BarDeploymentListener;
import org.activiti.osgi.BarURLHandler;
import org.activiti.osgi.BpmnDeploymentListener;
import org.activiti.osgi.BpmnURLHandler;
import org.activiti.osgi.Extender;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private List<Runnable> callbacks = new ArrayList<Runnable>();

    public void start(BundleContext context) throws Exception {
        this.callbacks.add(new Service(context, URLStreamHandlerService.class.getName(), (Object)new BpmnURLHandler(), Activator.props("url.handler.protocol", "bpmn")));
        this.callbacks.add(new Service(context, URLStreamHandlerService.class.getName(), (Object)new BarURLHandler(), Activator.props("url.handler.protocol", "bar")));
        try {
            this.callbacks.add(new Service(context, new String[]{ArtifactUrlTransformer.class.getName(), ArtifactListener.class.getName()}, (Object)new BpmnDeploymentListener(), null));
            this.callbacks.add(new Service(context, new String[]{ArtifactUrlTransformer.class.getName(), ArtifactListener.class.getName()}, (Object)new BarDeploymentListener(), null));
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("FileInstall package is not available, disabling fileinstall support");
            LOGGER.debug("FileInstall package is not available, disabling fileinstall support", (Throwable)e);
        }
        this.callbacks.add(new Tracker(new Extender(context)));
    }

    public void stop(BundleContext context) throws Exception {
        for (Runnable r : this.callbacks) {
            r.run();
        }
    }

    private static Dictionary<String, String> props(String ... args) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        for (int i = 0; i < args.length / 2; ++i) {
            ((Dictionary)props).put(args[2 * i], args[2 * i + 1]);
        }
        return props;
    }

    private static class Tracker
    implements Runnable {
        private final Extender extender;

        private Tracker(Extender extender) {
            this.extender = extender;
            this.extender.open();
        }

        @Override
        public void run() {
            this.extender.close();
        }
    }

    private static class Service
    implements Runnable {
        private final ServiceRegistration registration;

        public Service(BundleContext context, String clazz, Object service, Dictionary props) {
            this.registration = context.registerService(clazz, service, props);
        }

        public Service(BundleContext context, String[] clazz, Object service, Dictionary props) {
            this.registration = context.registerService(clazz, service, props);
        }

        @Override
        public void run() {
            this.registration.unregister();
        }
    }
}

