/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.connector;

import org.activiti.bpmn.model.ServiceTask;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.runtime.api.connector.Connector;
import org.activiti.runtime.api.connector.IntegrationContextBuilder;
import org.activiti.runtime.api.model.IntegrationContext;
import org.springframework.context.ApplicationContext;

public class DefaultServiceTaskBehavior
extends AbstractBpmnActivityBehavior {
    private final ApplicationContext applicationContext;
    private final IntegrationContextBuilder integrationContextBuilder;

    public DefaultServiceTaskBehavior(ApplicationContext applicationContext, IntegrationContextBuilder integrationContextBuilder) {
        this.applicationContext = applicationContext;
        this.integrationContextBuilder = integrationContextBuilder;
    }

    public void execute(DelegateExecution execution) {
        Connector connector = (Connector)this.applicationContext.getBean(this.getServiceTaskImplementation(execution), Connector.class);
        IntegrationContext context = this.integrationContextBuilder.from(execution);
        connector.execute(context);
        execution.setVariables(context.getOutBoundVariables());
        this.leave(execution);
    }

    private String getServiceTaskImplementation(DelegateExecution execution) {
        return ((ServiceTask)execution.getCurrentFlowElement()).getImplementation();
    }

    protected boolean hasConnectorBean(DelegateExecution execution) {
        String implementation = this.getServiceTaskImplementation(execution);
        return this.applicationContext.containsBean(implementation) && this.applicationContext.getBean(implementation) instanceof Connector;
    }
}

