/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.management;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ManagementService;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.management.TableResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Database tables"}, description="Manage Database tables", authorizations={@Authorization(value="basicAuth")})
public class TableResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected ManagementService managementService;

    @ApiOperation(value="Get a single table", tags={"Database tables"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the table exists and the table count is returned."), @ApiResponse(code=404, message="Indicates the requested table does not exist.")})
    @RequestMapping(value={"/management/tables/{tableName}"}, method={RequestMethod.GET}, produces={"application/json"})
    public TableResponse getTable(@ApiParam(name="tableName", value="The name of the table to get.") @PathVariable String tableName, HttpServletRequest request) {
        Map tableCounts = this.managementService.getTableCount();
        TableResponse response = null;
        for (Map.Entry entry : tableCounts.entrySet()) {
            if (!((String)entry.getKey()).equals(tableName)) continue;
            response = this.restResponseFactory.createTableResponse((String)entry.getKey(), (Long)entry.getValue());
            break;
        }
        if (response == null) {
            throw new ActivitiObjectNotFoundException("Could not find a table with name '" + tableName + "'.", String.class);
        }
        return response;
    }
}

