/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.Group;
import org.activiti.rest.exception.ActivitiConflictException;
import org.activiti.rest.service.api.identity.BaseGroupResource;
import org.activiti.rest.service.api.identity.MembershipRequest;
import org.activiti.rest.service.api.identity.MembershipResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Groups"}, description="Manage Groups", authorizations={@Authorization(value="basicAuth")})
public class GroupMembershipCollectionResource
extends BaseGroupResource {
    @ApiOperation(value="Add a member to a group", tags={"Groups"})
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the group was found and the member has been added."), @ApiResponse(code=400, message="Indicates the userId was not included in the request body."), @ApiResponse(code=404, message="Indicates the requested group was not found."), @ApiResponse(code=409, message="Indicates the requested user is already a member of the group.")})
    @RequestMapping(value={"/identity/groups/{groupId}/members"}, method={RequestMethod.POST}, produces={"application/json"})
    public MembershipResponse createMembership(@ApiParam(name="groupId", value="The id of the group to add a member to.") @PathVariable String groupId, @RequestBody MembershipRequest memberShip, HttpServletRequest request, HttpServletResponse response) {
        Group group = this.getGroupFromRequest(groupId);
        if (memberShip.getUserId() == null) {
            throw new ActivitiIllegalArgumentException("UserId cannot be null.");
        }
        if (this.identityService.createUserQuery().memberOfGroup(group.getId()).userId(memberShip.getUserId()).count() > 0L) {
            throw new ActivitiConflictException("User '" + memberShip.getUserId() + "' is already part of group '" + group.getId() + "'.");
        }
        this.identityService.createMembership(memberShip.getUserId(), group.getId());
        response.setStatus(HttpStatus.CREATED.value());
        return this.restResponseFactory.createMembershipResponse(memberShip.getUserId(), group.getId());
    }
}

