/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.management;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ManagementService;
import org.activiti.engine.management.TableMetaData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Database tables"}, description="Manage Database tables", authorizations={@Authorization(value="basicAuth")})
public class TableColumnsResource {
    @Autowired
    protected ManagementService managementService;

    @ApiOperation(value="Get column info for a single table", tags={"Database tables"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the table exists and the table column info is returned."), @ApiResponse(code=404, message="Indicates the requested table does not exist.")})
    @RequestMapping(value={"/management/tables/{tableName}/columns"}, method={RequestMethod.GET}, produces={"application/json"})
    public TableMetaData getTableMetaData(@ApiParam(name="tableName", value="The name of the table to get.") @PathVariable String tableName) {
        TableMetaData response = this.managementService.getTableMetaData(tableName);
        if (response == null) {
            throw new ActivitiObjectNotFoundException("Could not find a table with name '" + tableName + "'.", String.class);
        }
        return response;
    }
}

