/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.converter.step;

import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.workflow.simple.converter.WorkflowDefinitionConversion;
import org.activiti.workflow.simple.converter.step.BaseStepDefinitionConverter;
import org.activiti.workflow.simple.definition.DelayStepDefinition;
import org.activiti.workflow.simple.definition.StepDefinition;

public class DelayStepDefinitionConverter
extends BaseStepDefinitionConverter<DelayStepDefinition, IntermediateCatchEvent> {
    private static final long serialVersionUID = 1L;

    @Override
    public Class<? extends StepDefinition> getHandledClass() {
        return DelayStepDefinition.class;
    }

    @Override
    protected IntermediateCatchEvent createProcessArtifact(DelayStepDefinition stepDefinition, WorkflowDefinitionConversion conversion) {
        IntermediateCatchEvent event = new IntermediateCatchEvent();
        event.setId(conversion.getUniqueNumberedId("intermediateEvent"));
        event.setName(stepDefinition.getName());
        event.setDocumentation(stepDefinition.getDescription());
        TimerEventDefinition timer = new TimerEventDefinition();
        event.addEventDefinition((EventDefinition)timer);
        if (stepDefinition.getTimeDate() != null) {
            timer.setTimeDate(stepDefinition.getTimeDate());
        } else if (stepDefinition.getTimeDuration() != null) {
            timer.setTimeDuration(stepDefinition.getTimeDuration().toISO8601DurationString());
        }
        this.addFlowElement(conversion, (FlowElement)event, true);
        return event;
    }
}

