/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.converter.step;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.FormProperty;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Signal;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.workflow.simple.converter.WorkflowDefinitionConversion;
import org.activiti.workflow.simple.converter.step.BaseStepDefinitionConverter;
import org.activiti.workflow.simple.definition.FeedbackStepDefinition;
import org.activiti.workflow.simple.definition.StepDefinition;
import org.activiti.workflow.simple.util.JvmUtil;

public class FeedbackStepDefinitionConverter
extends BaseStepDefinitionConverter<FeedbackStepDefinition, Map<String, BaseElement>> {
    private static final long serialVersionUID = 1L;
    private static final String SELECT_PEOPLE_USER_TASK = "initiatorSelectPeopleTask";
    private static final String FEEDBACK_FORK = "feedbackFork";
    private static final String FEEDBACK_JOIN = "feedbackJoin";
    private static final String FEEDBACK_USER_TASK = "gatherFeedback";
    public static final String VARIABLE_FEEDBACK_PROVIDERS = "feedbackProviders";
    public static final String VARIABLE_FEEDBACK_PROVIDER = "feedbackProvider";

    @Override
    public Class<? extends StepDefinition> getHandledClass() {
        return FeedbackStepDefinition.class;
    }

    @Override
    protected Map<String, BaseElement> createProcessArtifact(FeedbackStepDefinition feedbackStepDefinition, WorkflowDefinitionConversion conversion) {
        HashMap<String, BaseElement> processElements = new HashMap<String, BaseElement>();
        UserTask selectPeopleUserTask = this.createSelectPeopleUserTask(feedbackStepDefinition, conversion, processElements);
        ParallelGateway fork = this.createForkParallelGateway(conversion, processElements);
        this.addSequenceFlow(conversion, (FlowNode)selectPeopleUserTask, (FlowNode)fork);
        UserTask gatherFeedbackUserTask = this.createGatherFeedbackUserTask(feedbackStepDefinition, conversion, processElements);
        this.addSequenceFlow(conversion, (FlowNode)fork, (FlowNode)gatherFeedbackUserTask);
        Signal signal = this.createSignalDeclaration(conversion);
        ThrowEvent signalThrowEvent = this.createSignalThrow(conversion, signal);
        this.addSequenceFlow(conversion, (FlowNode)gatherFeedbackUserTask, (FlowNode)signalThrowEvent);
        UserTask feedbackTask = this.createFeedbackUserTask(feedbackStepDefinition, conversion, processElements);
        this.addSequenceFlow(conversion, (FlowNode)fork, (FlowNode)feedbackTask);
        BoundaryEvent boundarySignalCatch = this.createBoundarySignalCatch(conversion, signal, feedbackTask);
        ExclusiveGateway mergingExclusiveGateway = this.createMergingExclusiveGateway(conversion);
        this.addSequenceFlow(conversion, (FlowNode)feedbackTask, (FlowNode)mergingExclusiveGateway);
        this.addSequenceFlow(conversion, (FlowNode)boundarySignalCatch, (FlowNode)mergingExclusiveGateway);
        ParallelGateway join = this.createJoinParallelGateway(conversion, processElements);
        this.addSequenceFlow(conversion, (FlowNode)signalThrowEvent, (FlowNode)join);
        this.addSequenceFlow(conversion, (FlowNode)mergingExclusiveGateway, (FlowNode)join);
        conversion.setLastActivityId(join.getId());
        return processElements;
    }

    protected UserTask createSelectPeopleUserTask(FeedbackStepDefinition feedbackStepDefinition, WorkflowDefinitionConversion conversion, Map<String, BaseElement> processElements) {
        UserTask selectPeopleUserTask = new UserTask();
        selectPeopleUserTask.setId(conversion.getUniqueNumberedId("userTask"));
        selectPeopleUserTask.setName(this.getSelectPeopleTaskName());
        selectPeopleUserTask.setAssignee(feedbackStepDefinition.getFeedbackInitiator());
        this.addFlowElement(conversion, (FlowElement)selectPeopleUserTask, true);
        processElements.put(SELECT_PEOPLE_USER_TASK, (BaseElement)selectPeopleUserTask);
        FormProperty feedbackProvidersProperty = new FormProperty();
        feedbackProvidersProperty.setId(VARIABLE_FEEDBACK_PROVIDERS);
        feedbackProvidersProperty.setName("Who needs to provide feedback?");
        feedbackProvidersProperty.setRequired(true);
        feedbackProvidersProperty.setType("string");
        selectPeopleUserTask.setFormProperties(Arrays.asList(feedbackProvidersProperty));
        if (feedbackStepDefinition.getFeedbackProviders() != null && !feedbackStepDefinition.getFeedbackProviders().isEmpty()) {
            if (selectPeopleUserTask.getTaskListeners() == null) {
                selectPeopleUserTask.setTaskListeners(new ArrayList());
            }
            ActivitiListener taskListener = new ActivitiListener();
            taskListener.setEvent("complete");
            taskListener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
            taskListener.setImplementation("org.activiti.engine.impl.bpmn.listener.ScriptTaskListener");
            FieldExtension languageField = new FieldExtension();
            languageField.setFieldName("language");
            languageField.setStringValue("JavaScript");
            FieldExtension scriptField = new FieldExtension();
            scriptField.setFieldName("script");
            StringBuilder script = new StringBuilder();
            if (JvmUtil.hasNashorn()) {
                script.append("load(\"nashorn:mozilla_compat.js\");");
            }
            script.append("importPackage (java.util); var feedbackProviders = new ArrayList();" + System.getProperty("line.separator"));
            for (String feedbackProvider : feedbackStepDefinition.getFeedbackProviders()) {
                script.append("feedbackProviders.add('" + feedbackProvider + "');" + System.getProperty("line.separator"));
            }
            script.append("task.getExecution().setVariable('feedbackProviders', feedbackProviders);" + System.getProperty("line.separator"));
            scriptField.setStringValue(script.toString());
            taskListener.setFieldExtensions(Arrays.asList(languageField, scriptField));
            selectPeopleUserTask.getTaskListeners().add(taskListener);
        }
        return selectPeopleUserTask;
    }

    protected ParallelGateway createForkParallelGateway(WorkflowDefinitionConversion conversion, Map<String, BaseElement> processElements) {
        ParallelGateway fork = new ParallelGateway();
        fork.setId(conversion.getUniqueNumberedId("gateway"));
        this.addFlowElement(conversion, (FlowElement)fork);
        processElements.put(FEEDBACK_FORK, (BaseElement)fork);
        return fork;
    }

    protected UserTask createGatherFeedbackUserTask(FeedbackStepDefinition feedbackStepDefinition, WorkflowDefinitionConversion conversion, Map<String, BaseElement> processElements) {
        UserTask gatherFeedbackUserTask = new UserTask();
        gatherFeedbackUserTask.setId(conversion.getUniqueNumberedId("userTask"));
        gatherFeedbackUserTask.setName(this.getGatherFeedbackTaskName());
        gatherFeedbackUserTask.setAssignee(feedbackStepDefinition.getFeedbackInitiator());
        this.addFlowElement(conversion, (FlowElement)gatherFeedbackUserTask);
        processElements.put(SELECT_PEOPLE_USER_TASK, (BaseElement)gatherFeedbackUserTask);
        return gatherFeedbackUserTask;
    }

    protected Signal createSignalDeclaration(WorkflowDefinitionConversion conversion) {
        Signal signal = new Signal();
        String uniqueSignalId = "signal-" + UUID.randomUUID().toString();
        signal.setId(uniqueSignalId);
        signal.setName(uniqueSignalId);
        signal.setScope("processInstance");
        conversion.getBpmnModel().addSignal(signal);
        return signal;
    }

    protected ThrowEvent createSignalThrow(WorkflowDefinitionConversion conversion, Signal signal) {
        ThrowEvent signalThrowEvent = new ThrowEvent();
        signalThrowEvent.setId(conversion.getUniqueNumberedId("event"));
        SignalEventDefinition signalThrowEventDefinition = new SignalEventDefinition();
        signalThrowEventDefinition.setSignalRef(signal.getId());
        signalThrowEvent.addEventDefinition((EventDefinition)signalThrowEventDefinition);
        this.addFlowElement(conversion, (FlowElement)signalThrowEvent);
        return signalThrowEvent;
    }

    protected ParallelGateway createJoinParallelGateway(WorkflowDefinitionConversion conversion, Map<String, BaseElement> processElements) {
        ParallelGateway join = new ParallelGateway();
        join.setId(conversion.getUniqueNumberedId("gateway"));
        this.addFlowElement(conversion, (FlowElement)join);
        processElements.put(FEEDBACK_JOIN, (BaseElement)join);
        return join;
    }

    protected UserTask createFeedbackUserTask(FeedbackStepDefinition feedbackStepDefinition, WorkflowDefinitionConversion conversion, Map<String, BaseElement> processElements) {
        UserTask feedbackTask = new UserTask();
        feedbackTask.setId(conversion.getUniqueNumberedId("userTask"));
        feedbackTask.setName(this.getProvideFeedbackTaskName());
        feedbackTask.setAssignee("${feedbackProvider}");
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
        multiInstanceLoopCharacteristics.setSequential(false);
        multiInstanceLoopCharacteristics.setInputDataItem(VARIABLE_FEEDBACK_PROVIDERS);
        multiInstanceLoopCharacteristics.setElementVariable(VARIABLE_FEEDBACK_PROVIDER);
        feedbackTask.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        this.addFlowElement(conversion, (FlowElement)feedbackTask);
        processElements.put(FEEDBACK_USER_TASK, (BaseElement)feedbackTask);
        return feedbackTask;
    }

    protected BoundaryEvent createBoundarySignalCatch(WorkflowDefinitionConversion conversion, Signal signal, UserTask feedbackTask) {
        BoundaryEvent boundarySignalCatch = new BoundaryEvent();
        boundarySignalCatch.setId(conversion.getUniqueNumberedId("boundaryEvent"));
        boundarySignalCatch.setAttachedToRef((Activity)feedbackTask);
        boundarySignalCatch.setAttachedToRefId(feedbackTask.getId());
        boundarySignalCatch.setCancelActivity(true);
        this.addFlowElement(conversion, (FlowElement)boundarySignalCatch);
        SignalEventDefinition signalCatchEventDefinition = new SignalEventDefinition();
        signalCatchEventDefinition.setSignalRef(signal.getId());
        boundarySignalCatch.addEventDefinition((EventDefinition)signalCatchEventDefinition);
        return boundarySignalCatch;
    }

    protected ExclusiveGateway createMergingExclusiveGateway(WorkflowDefinitionConversion conversion) {
        ExclusiveGateway mergingExclusiveGateway = new ExclusiveGateway();
        mergingExclusiveGateway.setId(conversion.getUniqueNumberedId("gateway"));
        this.addFlowElement(conversion, (FlowElement)mergingExclusiveGateway);
        return mergingExclusiveGateway;
    }

    protected String getSelectPeopleTaskName() {
        return "Choose people";
    }

    protected String getProvideFeedbackTaskName() {
        return "Provide feedback";
    }

    protected String getGatherFeedbackTaskName() {
        return "Gather feedback";
    }
}

