/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.boot;

import java.io.IOException;
import java.util.List;
import javax.sql.DataSource;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.spring.ProcessEngineFactoryBean;
import org.activiti.spring.SpringAsyncExecutor;
import org.activiti.spring.SpringCallerRunsRejectedJobsHandler;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.activiti.spring.SpringRejectedJobsHandler;
import org.activiti.spring.boot.AbstractProcessEngineConfiguration;
import org.activiti.spring.boot.ActivitiProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;

public abstract class AbstractProcessEngineAutoConfiguration
extends AbstractProcessEngineConfiguration {
    protected ActivitiProperties activitiProperties;
    @Autowired
    private ResourcePatternResolver resourceLoader;

    @Bean
    public SpringAsyncExecutor springAsyncExecutor(TaskExecutor taskExecutor) {
        return new SpringAsyncExecutor(taskExecutor, this.springRejectedJobsHandler());
    }

    @Bean
    public SpringRejectedJobsHandler springRejectedJobsHandler() {
        return new SpringCallerRunsRejectedJobsHandler();
    }

    protected SpringProcessEngineConfiguration baseSpringProcessEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager, SpringAsyncExecutor springAsyncExecutor) throws IOException {
        List<Resource> procDefResources = this.discoverProcessDefinitionResources(this.resourceLoader, this.activitiProperties.getProcessDefinitionLocationPrefix(), this.activitiProperties.getProcessDefinitionLocationSuffix(), this.activitiProperties.isCheckProcessDefinitions());
        SpringProcessEngineConfiguration conf = super.processEngineConfigurationBean(procDefResources.toArray(new Resource[procDefResources.size()]), dataSource, platformTransactionManager, springAsyncExecutor);
        conf.setDeploymentName(this.defaultText(this.activitiProperties.getDeploymentName(), conf.getDeploymentName()));
        conf.setDatabaseSchema(this.defaultText(this.activitiProperties.getDatabaseSchema(), conf.getDatabaseSchema()));
        conf.setDatabaseSchemaUpdate(this.defaultText(this.activitiProperties.getDatabaseSchemaUpdate(), conf.getDatabaseSchemaUpdate()));
        conf.setJobExecutorActivate(this.activitiProperties.isJobExecutorActivate());
        conf.setAsyncExecutorEnabled(this.activitiProperties.isAsyncExecutorEnabled());
        conf.setAsyncExecutorActivate(this.activitiProperties.isAsyncExecutorActivate());
        conf.setMailServerHost(this.activitiProperties.getMailServerHost());
        conf.setMailServerPort(this.activitiProperties.getMailServerPort());
        conf.setMailServerUsername(this.activitiProperties.getMailServerUserName());
        conf.setMailServerPassword(this.activitiProperties.getMailServerPassword());
        conf.setMailServerDefaultFrom(this.activitiProperties.getMailServerDefaultFrom());
        conf.setMailServerUseSSL(this.activitiProperties.isMailServerUseSsl());
        conf.setMailServerUseTLS(this.activitiProperties.isMailServerUseTls());
        return conf;
    }

    private String defaultText(String deploymentName, String deploymentName1) {
        if (StringUtils.hasText((String)deploymentName)) {
            return deploymentName;
        }
        return deploymentName1;
    }

    @Autowired
    protected void setActivitiProperties(ActivitiProperties activitiProperties) {
        this.activitiProperties = activitiProperties;
    }

    protected ActivitiProperties getActivitiProperties() {
        return this.activitiProperties;
    }

    @Bean
    public ProcessEngineFactoryBean processEngine(SpringProcessEngineConfiguration configuration) throws Exception {
        return super.springProcessEngineBean(configuration);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    public RuntimeService runtimeServiceBean(ProcessEngine processEngine) {
        return super.runtimeServiceBean(processEngine);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    public RepositoryService repositoryServiceBean(ProcessEngine processEngine) {
        return super.repositoryServiceBean(processEngine);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    public TaskService taskServiceBean(ProcessEngine processEngine) {
        return super.taskServiceBean(processEngine);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    public HistoryService historyServiceBean(ProcessEngine processEngine) {
        return super.historyServiceBean(processEngine);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    public ManagementService managementServiceBeanBean(ProcessEngine processEngine) {
        return super.managementServiceBeanBean(processEngine);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    public FormService formServiceBean(ProcessEngine processEngine) {
        return super.formServiceBean(processEngine);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    public IdentityService identityServiceBean(ProcessEngine processEngine) {
        return super.identityServiceBean(processEngine);
    }

    @Bean
    @ConditionalOnMissingBean
    public TaskExecutor taskExecutor() {
        return new SimpleAsyncTaskExecutor();
    }
}

