/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.boot;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.activiti.engine.ProcessEngine;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.activiti.spring.annotations.ActivitiConfigurer;
import org.activiti.spring.annotations.EnableActiviti;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

@Configuration
@ConditionalOnClass(value={ProcessEngine.class, EnableActiviti.class})
@ConditionalOnBean(value={DataSource.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@ConditionalOnMissingBean(value={ProcessEngine.class})
public class ProcessEngineAutoConfiguration {

    @Configuration
    @EnableActiviti
    public static class DefaultActivitiConfiguration
    implements ActivitiConfigurer,
    EnvironmentAware {
        private Log log = LogFactory.getLog(this.getClass());
        public static final String PROCESS_DEFINITIONS_DEFAULT_PREFIX = "classpath:/processes/";
        public static final String PROCESS_DEFINITIONS_DEFAULT_SUFFIX = "**.bpmn20.xml";
        private RelaxedPropertyResolver environment;
        @Autowired
        private DataSource[] dataSources;
        @Autowired
        private ResourcePatternResolver applicationContext;

        public void processDefinitionResources(List<Resource> resourceList) {
            List<Resource> resources;
            try {
                String prefix = this.environment.getProperty("prefix", PROCESS_DEFINITIONS_DEFAULT_PREFIX);
                String suffix = this.environment.getProperty("suffix", PROCESS_DEFINITIONS_DEFAULT_SUFFIX);
                String path = prefix + suffix;
                if (((Boolean)this.environment.getProperty("checkProcessDefinitions", Boolean.class, (Object)true)).booleanValue()) {
                    Assert.state((boolean)this.applicationContext.getResource(prefix).exists(), (String)String.format("No process definitions were found deployed at %s. Are you actually using Activiti? ", path));
                }
                resources = Arrays.asList(this.applicationContext.getResources(path));
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)String.format("found %s process definitions in %s.", resources.size(), prefix));
                    for (Resource resource : resources) {
                        this.log.info((Object)String.format("found process definition: %s", resource.getURI().toString()));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            resourceList.addAll(resources);
        }

        public void postProcessSpringProcessEngineConfiguration(SpringProcessEngineConfiguration config) {
            config.setDeploymentName(this.environment.getProperty("deploymentName", config.getDeploymentName()));
            config.setDatabaseSchemaUpdate(this.environment.getProperty("databaseSchemaUpdate", config.getDatabaseSchemaUpdate()));
            config.setDatabaseSchema(this.environment.getProperty("databaseSchema", config.getDatabaseSchema()));
        }

        public DataSource dataSource() {
            Assert.isTrue((this.dataSources.length > 0 ? 1 : 0) != 0, (String)"you must have configured at least one javax.sql.DataSource bean in your Spring application context.");
            return this.dataSources[0];
        }

        public void setEnvironment(Environment environment) {
            this.environment = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.activiti.");
        }
    }
}

