/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.conformance.util.security;

import java.util.Collection;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;

public class SecurityUtil {
    private Logger logger = LoggerFactory.getLogger(SecurityUtil.class);
    private final UserDetailsService userDetailsService;
    private final SecurityManager securityManager;

    public SecurityUtil(UserDetailsService userDetailsService, SecurityManager securityManager) {
        this.userDetailsService = userDetailsService;
        this.securityManager = securityManager;
    }

    public void logInAs(String username) {
        final UserDetails user = this.userDetailsService.loadUserByUsername(username);
        if (user == null) {
            throw new IllegalStateException("User " + username + " doesn't exist, please provide a valid user");
        }
        this.logger.info("> Logged in as: " + username);
        SecurityContextHolder.setContext((SecurityContext)new SecurityContextImpl(new Authentication(){

            public Collection<? extends GrantedAuthority> getAuthorities() {
                return user.getAuthorities();
            }

            public Object getCredentials() {
                return user.getPassword();
            }

            public Object getDetails() {
                return user;
            }

            public Object getPrincipal() {
                return user;
            }

            public boolean isAuthenticated() {
                return true;
            }

            public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
            }

            public String getName() {
                return user.getUsername();
            }
        }));
        org.activiti.engine.impl.identity.Authentication.setAuthenticatedUserId((String)username);
        Assertions.assertThat((String)this.securityManager.getAuthenticatedUserId()).isEqualTo((Object)username);
    }
}

