/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.security.policies;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.runtime.api.identity.UserGroupManager;
import org.activiti.runtime.api.security.SecurityManager;
import org.activiti.spring.security.policies.SecurityPoliciesManager;
import org.activiti.spring.security.policies.SecurityPolicy;
import org.activiti.spring.security.policies.SecurityPolicyAccess;
import org.activiti.spring.security.policies.conf.SecurityPoliciesProperties;

public abstract class BaseSecurityPoliciesManagerImpl
implements SecurityPoliciesManager {
    protected UserGroupManager userGroupManager;
    protected SecurityManager securityManager;
    protected SecurityPoliciesProperties securityPoliciesProperties;

    public BaseSecurityPoliciesManagerImpl(UserGroupManager userGroupManager, SecurityManager securityManager, SecurityPoliciesProperties securityPoliciesProperties) {
        this.userGroupManager = userGroupManager;
        this.securityManager = securityManager;
        this.securityPoliciesProperties = securityPoliciesProperties;
    }

    @Override
    public boolean arePoliciesDefined() {
        return !this.securityPoliciesProperties.getPolicies().isEmpty();
    }

    @Override
    public Map<String, Set<String>> getAllowedKeys(SecurityPolicyAccess ... securityPoliciesAccess) {
        String authenticatedUserId = this.securityManager.getAuthenticatedUserId();
        List userRoles = this.userGroupManager.getUserRoles(authenticatedUserId);
        List<SecurityPolicy> policies = this.securityPoliciesProperties.getPolicies();
        HashMap<String, Set<String>> definitionKeysAllowedByPolicy = new HashMap<String, Set<String>>();
        List groups = null;
        if (this.userGroupManager != null && authenticatedUserId != null) {
            groups = this.userGroupManager.getUserGroups(authenticatedUserId);
        }
        for (SecurityPolicy ssp : policies) {
            definitionKeysAllowedByPolicy.computeIfAbsent(ssp.getServiceName(), k -> new HashSet());
            if (!this.isUserInPolicy(ssp, authenticatedUserId) && !this.isGroupInPolicy(ssp, groups)) continue;
            List<SecurityPolicyAccess> securityPolicyAccesses = Arrays.asList(securityPoliciesAccess);
            if (securityPolicyAccesses.contains((Object)SecurityPolicyAccess.WRITE)) {
                if (!ssp.getAccess().equals((Object)SecurityPolicyAccess.WRITE)) continue;
                ((Set)definitionKeysAllowedByPolicy.get(ssp.getServiceName())).addAll(ssp.getKeys());
                continue;
            }
            if (!securityPolicyAccesses.contains((Object)SecurityPolicyAccess.READ) || !ssp.getAccess().equals((Object)SecurityPolicyAccess.READ) && !ssp.getAccess().equals((Object)SecurityPolicyAccess.WRITE)) continue;
            ((Set)definitionKeysAllowedByPolicy.get(ssp.getServiceName())).addAll(ssp.getKeys());
        }
        return definitionKeysAllowedByPolicy;
    }

    private boolean isUserInPolicy(SecurityPolicy ssp, String userId) {
        return ssp.getUsers() != null && !ssp.getUsers().isEmpty() && ssp.getUsers().contains(userId);
    }

    private boolean isGroupInPolicy(SecurityPolicy ssp, List<String> groups) {
        if (ssp.getGroups() != null && groups != null) {
            for (String g : ssp.getGroups()) {
                if (!groups.contains(g)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canRead(String processDefinitionKey, String appName) {
        return this.hasPermission(processDefinitionKey, SecurityPolicyAccess.READ, appName);
    }

    @Override
    public boolean canWrite(String processDefinitionKey, String appName) {
        return this.hasPermission(processDefinitionKey, SecurityPolicyAccess.WRITE, appName);
    }

    public boolean hasPermission(String processDefinitionKey, SecurityPolicyAccess securityPolicyAccess, String appName) {
        if (this.securityPoliciesProperties.getPolicies().isEmpty()) {
            return true;
        }
        if (this.userGroupManager.getUserRoles(this.securityManager.getAuthenticatedUserId()).contains("ACTIVITI_ADMIN")) {
            return true;
        }
        HashSet<String> keys = new HashSet<String>();
        Map<String, Set<String>> policiesMap = this.getAllowedKeys(securityPolicyAccess);
        if (policiesMap.get(appName) != null) {
            keys.addAll((Collection)policiesMap.get(appName));
        }
        if (appName != null && policiesMap.get(appName.replaceAll("-", "").toLowerCase()) != null) {
            keys.addAll((Collection<String>)policiesMap.get(appName.replaceAll("-", "").toLowerCase()));
        }
        return this.anEntryInSetStartsKey(keys, processDefinitionKey) || keys.contains(this.securityPoliciesProperties.getWildcard());
    }

    protected boolean anEntryInSetStartsKey(Set<String> keys, String processDefinitionKey) {
        for (String key : keys) {
            if (!processDefinitionKey.startsWith(key)) continue;
            return true;
        }
        return false;
    }

    protected SecurityPoliciesProperties getSecurityPoliciesProperties() {
        return this.securityPoliciesProperties;
    }
}

