/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.autodeployment;

import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.spring.autodeployment.AbstractAutoDeploymentStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class NeverFailAutoDeploymentStrategy
extends AbstractAutoDeploymentStrategy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(NeverFailAutoDeploymentStrategy.class);
    public static final String DEPLOYMENT_MODE = "never-fail";

    @Override
    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    @Override
    public void deployResources(String deploymentNameHint, Resource[] resources, RepositoryService repositoryService) {
        DeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(deploymentNameHint);
        int validProcessCount = 0;
        for (Resource resource : resources) {
            String resourceName = this.determineResourceName(resource);
            if (this.validateModel(resource, repositoryService)) {
                ++validProcessCount;
                deploymentBuilder.addInputStream(resourceName, resource);
                continue;
            }
            LOGGER.error("The following resource wasn't included in the deployment since it is invalid:\n{}", (Object)resourceName);
        }
        if (validProcessCount != 0) {
            deploymentBuilder.deploy();
        }
    }
}

