/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti5.engine.delegate.BpmnError;
import org.activiti5.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti5.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti5.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.pvm.delegate.ActivityExecution;
import org.apache.commons.lang3.StringUtils;

public class ServiceTaskExpressionActivityBehavior
extends TaskActivityBehavior {
    protected String serviceTaskId;
    protected Expression expression;
    protected Expression skipExpression;
    protected String resultVariable;

    public ServiceTaskExpressionActivityBehavior(String serviceTaskId, Expression expression, Expression skipExpression, String resultVariable) {
        this.serviceTaskId = serviceTaskId;
        this.expression = expression;
        this.skipExpression = skipExpression;
        this.resultVariable = resultVariable;
    }

    @Override
    public void execute(DelegateExecution execution) {
        ActivityExecution activityExecution = (ActivityExecution)execution;
        Object value = null;
        try {
            boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(activityExecution, this.skipExpression);
            if (!isSkipExpressionEnabled || isSkipExpressionEnabled && !SkipExpressionUtil.shouldSkipFlowElement(activityExecution, this.skipExpression)) {
                String overrideExpression;
                ObjectNode taskElementProperties;
                if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache() && (taskElementProperties = Context.getBpmnOverrideElementProperties(this.serviceTaskId, execution.getProcessDefinitionId())) != null && taskElementProperties.has("serviceTaskExpression") && StringUtils.isNotEmpty((CharSequence)(overrideExpression = taskElementProperties.get("serviceTaskExpression").asText())) && !overrideExpression.equals(this.expression.getExpressionText())) {
                    this.expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideExpression);
                }
                value = this.expression.getValue((VariableScope)execution);
                if (this.resultVariable != null) {
                    execution.setVariable(this.resultVariable, value);
                }
            }
            this.leave(activityExecution);
        }
        catch (Exception exc) {
            BpmnError error = null;
            for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof BpmnError)) continue;
                error = (BpmnError)cause;
                break;
            }
            if (error != null) {
                ErrorPropagation.propagateError(error, activityExecution);
            }
            throw new ActivitiException(exc.getMessage(), (Throwable)exc);
        }
    }
}

