/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.bpmn.helper;

import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.impl.bpmn.helper.BaseDelegateEventListener;
import org.activiti5.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.impl.pvm.delegate.ActivityExecution;

public class ErrorThrowingEventListener
extends BaseDelegateEventListener {
    protected String errorCode;

    public void onEvent(ActivitiEvent event) {
        if (this.isValidEvent(event)) {
            ExecutionEntity execution = null;
            if (Context.isExecutionContextActive()) {
                execution = Context.getExecutionContext().getExecution();
            } else if (event.getExecutionId() != null) {
                execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(event.getExecutionId());
            }
            if (execution == null) {
                throw new ActivitiException("No execution context active and event is not related to an execution. No compensation event can be thrown.");
            }
            try {
                ErrorPropagation.propagateError(this.errorCode, (ActivityExecution)execution);
            }
            catch (Exception e) {
                throw new ActivitiException("Error while propagating error-event", e);
            }
        }
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public boolean isFailOnException() {
        return true;
    }
}

