/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.identity.Picture;
import org.activiti5.engine.identity.User;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;

public class GetUserPictureCmd
implements Command<Picture>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String userId;

    public GetUserPictureCmd(String userId) {
        this.userId = userId;
    }

    @Override
    public Picture execute(CommandContext commandContext) {
        if (this.userId == null) {
            throw new ActivitiIllegalArgumentException("userId is null");
        }
        User user = commandContext.getUserIdentityManager().findUserById(this.userId);
        if (user == null) {
            throw new ActivitiObjectNotFoundException("user " + this.userId + " doesn't exist", User.class);
        }
        return commandContext.getUserIdentityManager().getUserPicture(this.userId);
    }
}

