/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.event;

import java.util.Map;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.event.AbstractEventHandler;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti5.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti5.engine.impl.pvm.process.ActivityImpl;

public class SignalEventHandler
extends AbstractEventHandler {
    public static final String EVENT_HANDLER_TYPE = "signal";

    @Override
    public String getEventHandlerType() {
        return EVENT_HANDLER_TYPE;
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        if (eventSubscription.getExecutionId() != null) {
            super.handleEvent(eventSubscription, payload, commandContext);
        } else if (eventSubscription.getProcessDefinitionId() != null) {
            String processDefinitionId = eventSubscription.getProcessDefinitionId();
            DeploymentManager deploymentCache = Context.getProcessEngineConfiguration().getDeploymentManager();
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("No process definition found for id '" + processDefinitionId + "'", ProcessDefinition.class);
            }
            if (processDefinition.isSuspended()) {
                throw new ActivitiException("Could not handle signal: process definition with id: " + processDefinitionId + " is suspended");
            }
            ActivityImpl startActivity = processDefinition.findActivity(eventSubscription.getActivityId());
            if (startActivity == null) {
                throw new ActivitiException("Could no handle signal: no start activity found with id " + eventSubscription.getActivityId());
            }
            ExecutionEntity processInstance = processDefinition.createProcessInstance(null, startActivity);
            if (processInstance == null) {
                throw new ActivitiException("Could not handle signal: no process instance started");
            }
            if (payload != null && payload instanceof Map) {
                Map variables = (Map)payload;
                processInstance.setVariables(variables);
            }
            processInstance.start();
        } else {
            throw new ActivitiException("Invalid signal handling: no execution nor process definition set");
        }
    }
}

